/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spatial;

import com.querydsl.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.db.sqlserver.Decoders;
import org.geolatte.geom.codec.db.sqlserver.Encoders;
import org.jetbrains.annotations.Nullable;

class SQLServerGeometryType
extends AbstractType<Geometry> {
    public static final SQLServerGeometryType DEFAULT = new SQLServerGeometryType();
    private static final int DEFAULT_SRID = 4326;

    SQLServerGeometryType() {
        super(2004);
    }

    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            return Decoders.decode((byte[])bytes);
        }
        return null;
    }

    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        byte[] bytes = Encoders.encode((Geometry)value);
        st.setBytes(startIndex, bytes);
    }

    public String getLiteral(Geometry geometry) {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry);
        if (geometry.getSRID() > -1) {
            return "geometry::STGeomFromText('" + str + "', " + geometry.getSRID() + ")";
        }
        return "geometry::STGeomFromText('" + str + "', " + 4326 + ")";
    }
}

