/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.binary.OChannelBinarySynchClient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class ORemoteServerChannel {
    private final ODistributedServerManager manager;
    private final String url;
    private final String remoteHost;
    private final int remotePort;
    private final String userName;
    private final String userPassword;
    private final String server;
    private OChannelBinarySynchClient channel;
    private static final int MAX_RETRY = 3;
    private static final String CLIENT_TYPE = "OrientDB Server";
    private static final boolean COLLECT_STATS = false;
    private int sessionId = -1;
    private byte[] sessionToken;
    private OContextConfiguration contextConfig = new OContextConfiguration();

    public ORemoteServerChannel(ODistributedServerManager manager, String iServer, String iURL, String user, String passwd) throws IOException {
        this.manager = manager;
        this.server = iServer;
        this.url = iURL;
        this.userName = user;
        this.userPassword = passwd;
        int sepPos = iURL.lastIndexOf(":");
        this.remoteHost = iURL.substring(0, sepPos);
        this.remotePort = Integer.parseInt(iURL.substring(sepPos + 1));
        this.connect();
    }

    public void sendRequest(final ODistributedRequest req, final String node) {
        this.networkOperation((byte)120, new OStorageRemoteOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws IOException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        try {
                            req.writeExternal(outStream);
                            byte[] serializedRequest = out.toByteArray();
                            ODistributedServerLog.debug((Object)this, ORemoteServerChannel.this.manager.getLocalNodeName(), node, ODistributedServerLog.DIRECTION.OUT, "Sending request %s (%d bytes)", req, serializedRequest.length);
                            ORemoteServerChannel.this.channel.writeBytes(serializedRequest);
                        }
                        finally {
                            outStream.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    ORemoteServerChannel.this.channel.flush();
                }
                return null;
            }
        }, "Cannot send distributed request", 3, true);
    }

    public void sendResponse(final ODistributedResponse response, final String node) {
        this.networkOperation((byte)121, new OStorageRemoteOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws IOException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        try {
                            response.writeExternal(outStream);
                            byte[] serializedResponse = out.toByteArray();
                            ODistributedServerLog.debug((Object)this, ORemoteServerChannel.this.manager.getLocalNodeName(), node, ODistributedServerLog.DIRECTION.OUT, "Sending response %s (%d bytes)", response, serializedResponse.length);
                            ORemoteServerChannel.this.channel.writeBytes(serializedResponse);
                        }
                        finally {
                            outStream.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    ORemoteServerChannel.this.channel.flush();
                }
                return null;
            }
        }, "Cannot send response back to the sender node '" + response.getSenderNodeName() + "'", 3, true);
    }

    public void connect() throws IOException {
        this.channel = new OChannelBinarySynchClient(this.remoteHost, this.remotePort, null, this.contextConfig, 36);
        this.networkOperation((byte)2, new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute() throws IOException {
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.CLIENT_TYPE).writeString("2.2.0").writeShort((short)36).writeString("0");
                ORemoteServerChannel.this.channel.writeString(ODatabaseDocumentTx.getDefaultSerializer().toString());
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.this.userName);
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.this.userPassword);
                ORemoteServerChannel.this.channel.flush();
                ORemoteServerChannel.this.channel.beginResponse(false);
                ORemoteServerChannel.this.sessionId = ORemoteServerChannel.this.channel.readInt();
                ORemoteServerChannel.access$502(ORemoteServerChannel.this, ORemoteServerChannel.this.channel.readBytes());
                if (ORemoteServerChannel.this.sessionToken.length == 0) {
                    ORemoteServerChannel.access$502(ORemoteServerChannel.this, null);
                }
                return null;
            }
        }, "Cannot connect to the remote server '" + this.url + "'", 3, false);
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.sessionId = -1;
        this.sessionToken = null;
    }

    protected synchronized <T> T networkOperation(byte operationId, OStorageRemoteOperation<T> operation, String errorMessage, int maxRetry, boolean autoReconnect) {
        Exception lastException = null;
        for (int retry = 1; retry <= maxRetry; ++retry) {
            try {
                this.channel.setWaitResponseTimeout();
                this.channel.beginRequest(operationId, this.sessionId, this.sessionToken);
                return operation.execute();
            }
            catch (Exception e) {
                lastException = e;
                this.close();
                if (!autoReconnect) break;
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on sending message to distributed node (%s) retrying (%d/%d)", lastException.toString(), retry, maxRetry);
                try {
                    Thread.sleep(100 * (retry * 2));
                }
                catch (InterruptedException e1) {
                    break;
                }
                if (!this.manager.isNodeAvailable(this.server)) break;
                try {
                    this.connect();
                }
                catch (IOException e1) {
                    lastException = e1;
                    ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on reconnecting to distributed node (%s)", lastException.toString());
                }
                continue;
            }
        }
        throw OException.wrapException((OException)((Object)new OStorageException(errorMessage)), (Throwable)lastException);
    }

    static /* synthetic */ byte[] access$502(ORemoteServerChannel x0, byte[] x1) {
        x0.sessionToken = x1;
        return x1;
    }

    public static interface OStorageRemoteOperation<T> {
        public T execute() throws IOException;
    }
}

