/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.OServer;
import java.util.concurrent.ConcurrentHashMap;

public class OSystemDatabase {
    public static final String SYSTEM_DB_NAME = "OSystem";
    private final OServer server;

    public OSystemDatabase(OServer server) {
        this.server = server;
        this.init();
    }

    public String getSystemDatabaseName() {
        return SYSTEM_DB_NAME;
    }

    public String getSystemDatabasePath() {
        return this.server.getDatabaseDirectory() + this.getSystemDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(OCallable<Object, Object> callback, String serverUser, String sql, Object ... args) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            Object object;
            ODatabaseDocumentTx db = this.server.openDatabase(this.getSystemDatabaseName(), serverUser, "", null, true);
            try {
                Object result = db.command((OCommandRequest)new OCommandSQL(sql)).execute(args);
                object = callback.call(result);
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return object;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument save(ODocument document, String serverUser) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            ODocument oDocument;
            ODatabaseDocumentTx db = this.server.openDatabase(this.getSystemDatabaseName(), serverUser, "", null, true);
            try {
                oDocument = (ODocument)db.save((ORecord)document);
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return oDocument;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ODatabaseDocumentInternal oldDbInThread = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            ODatabaseDocumentTx sysDB = new ODatabaseDocumentTx("plocal:" + this.getSystemDatabasePath());
            if (!sysDB.exists()) {
                OLogManager.instance().info((Object)this, "Creating the system database '%s' for current server", new Object[]{SYSTEM_DB_NAME});
                ConcurrentHashMap<OGlobalConfiguration, Comparable<Boolean>> settings = new ConcurrentHashMap<OGlobalConfiguration, Comparable<Boolean>>();
                settings.put(OGlobalConfiguration.CREATE_DEFAULT_USERS, Boolean.valueOf(false));
                settings.put(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, Integer.valueOf(1));
                sysDB.create(settings);
                sysDB.close();
            }
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDBScope(OCallable<Void, ODatabase> callback, String serverUser) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            ODatabaseDocumentTx db = this.server.openDatabase(this.getSystemDatabaseName(), serverUser, "", null, true);
            try {
                callback.call((Object)db);
            }
            finally {
                db.close();
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ODatabaseDocumentInternal oldDbInThread = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            ODatabaseDocumentTx sysDB = new ODatabaseDocumentTx("plocal:" + this.getSystemDatabasePath());
            boolean bl = sysDB.exists();
            return bl;
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        }
    }
}

