/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageMapParser {
    private static final String IMG_USEMAP_ATTR = "usemap";
    private static final String MAP_ELT = "map";
    private static final String MAP_NAME_ATTR = "name";
    private static final String AREA_ELT = "area";
    private static final String AREA_SHAPE_ATTR = "shape";
    private static final String AREA_COORDS_ATTR = "coords";
    private static final String AREA_HREF_ATTR = "href";
    private static final String RECT_SHAPE = "rect";
    private static final String RECTANGLE_SHAPE = "rectangle";
    private static final String CIRC_SHAPE = "circ";
    private static final String CIRCLE_SHAPE = "circle";
    private static final String POLY_SHAPE = "poly";
    private static final String POLYGON_SHAPE = "polygon";

    public static Map<Shape, String> findAndParseMap(Element elem, SharedContext c) {
        String usemapAttr = elem.getAttribute(IMG_USEMAP_ATTR);
        if (usemapAttr == null || usemapAttr.isEmpty()) {
            return null;
        }
        String mapName = usemapAttr.substring(1);
        Node map = elem.getOwnerDocument().getElementById(mapName);
        if (null == map) {
            NodeList maps = elem.getOwnerDocument().getElementsByTagName(MAP_ELT);
            for (int i = 0; i < maps.getLength(); ++i) {
                String mapAttr = ImageMapParser.getAttribute(maps.item(i).getAttributes(), MAP_NAME_ATTR);
                if (!ImageMapParser.areEqual(mapName, mapAttr)) continue;
                map = maps.item(i);
                break;
            }
            if (null == map) {
                XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LAYOUT_NO_MAP_NAMED, mapName);
                return null;
            }
        }
        return ImageMapParser.parseMap(map, c);
    }

    private static boolean areEqual(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equals(str2);
    }

    private static boolean areEqualIgnoreCase(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equalsIgnoreCase(str2);
    }

    private static Map<Shape, String> parseMap(Node map, SharedContext c) {
        if (null == map) {
            return Collections.emptyMap();
        }
        if (map.hasChildNodes()) {
            AffineTransform scaleInstance = AffineTransform.getScaleInstance(c.getDotsPerPixel(), c.getDotsPerPixel());
            NodeList children = map.getChildNodes();
            HashMap<Shape, String> areas = new HashMap<Shape, String>(children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                Shape shape;
                Node area = children.item(i);
                if (!ImageMapParser.areEqualIgnoreCase(AREA_ELT, area.getNodeName()) || !area.hasAttributes()) continue;
                NamedNodeMap attrs = area.getAttributes();
                String shapeAttr = ImageMapParser.getAttribute(attrs, AREA_SHAPE_ATTR);
                String coordsAttr = ImageMapParser.getAttribute(attrs, AREA_COORDS_ATTR);
                if (coordsAttr == null) continue;
                String[] coords = coordsAttr.split(",");
                String href = ImageMapParser.getAttribute(attrs, AREA_HREF_ATTR);
                if (ImageMapParser.areEqualIgnoreCase(RECT_SHAPE, shapeAttr) || ImageMapParser.areEqualIgnoreCase(RECTANGLE_SHAPE, shapeAttr)) {
                    shape = ImageMapParser.getCoords(coords, 4);
                    if (null == shape) continue;
                    areas.put(scaleInstance.createTransformedShape(shape), href);
                    continue;
                }
                if (ImageMapParser.areEqualIgnoreCase(CIRC_SHAPE, shapeAttr) || ImageMapParser.areEqualIgnoreCase(CIRCLE_SHAPE, shapeAttr)) {
                    shape = ImageMapParser.getCoords(coords, 3);
                    if (null == shape) continue;
                    areas.put(scaleInstance.createTransformedShape(shape), href);
                    continue;
                }
                if (ImageMapParser.areEqualIgnoreCase(POLY_SHAPE, shapeAttr) || ImageMapParser.areEqualIgnoreCase(POLYGON_SHAPE, shapeAttr)) {
                    shape = ImageMapParser.getCoords(coords, -1);
                    if (null == shape) continue;
                    areas.put(scaleInstance.createTransformedShape(shape), href);
                    continue;
                }
                if (!XRLog.isLoggingEnabled()) continue;
                XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LAYOUT_UNSUPPORTED_SHAPE, shapeAttr);
            }
            return areas;
        }
        return Collections.emptyMap();
    }

    private static String getAttribute(NamedNodeMap attrs, String attrName) {
        Node node = attrs.getNamedItem(attrName);
        return null == node ? null : node.getNodeValue();
    }

    private static Shape getCoords(String[] coordValues, int length) {
        if (-1 == length && 0 == coordValues.length % 2 || length == coordValues.length) {
            float[] coords = new float[coordValues.length];
            int i = 0;
            for (String coord : coordValues) {
                try {
                    coords[i++] = Float.parseFloat(coord.trim());
                }
                catch (NumberFormatException e) {
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.LAYOUT_ERROR_PARSING_SHAPE_COORDS, e);
                    return null;
                }
            }
            if (4 == length) {
                return new Rectangle2D.Float(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
            }
            if (3 == length) {
                float radius = coords[2];
                return new Ellipse2D.Float(coords[0] - radius, coords[1] - radius, radius * 2.0f, radius * 2.0f);
            }
            if (-1 == length) {
                int npoints = coords.length / 2;
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                int c = 0;
                for (int p = 0; p < npoints; ++p) {
                    xpoints[p] = (int)coords[c++];
                    ypoints[p] = (int)coords[c++];
                }
                return new Polygon(xpoints, ypoints, npoints);
            }
            XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LAYOUT_UNSUPPORTED_SHAPE, length);
            return null;
        }
        return null;
    }
}

