/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IHttpStreamRequest;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseStreamRequest<T>
implements IHttpStreamRequest {
    private final BaseRequest<T> baseRequest;

    public BaseStreamRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options, @Nonnull Class<T> responseClass) {
        this.baseRequest = new BaseRequest<T>(requestUrl, client, options, responseClass){};
    }

    @Nonnull
    protected CompletableFuture<InputStream> sendAsync() {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return this.baseRequest.getClient().getHttpProvider().sendAsync(this, InputStream.class, null);
    }

    @Nullable
    protected InputStream send() throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return this.baseRequest.getClient().getHttpProvider().send(this, InputStream.class, null);
    }

    @Nonnull
    protected CompletableFuture<T> sendAsync(@Nonnull byte[] fileContents) {
        Objects.requireNonNull(fileContents, "parameter fileContents cannot be null");
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        return this.baseRequest.getClient().getHttpProvider().sendAsync(this, this.baseRequest.getResponseType(), fileContents);
    }

    @Nullable
    protected T send(@Nonnull byte[] fileContents) {
        Objects.requireNonNull(fileContents, "parameter fileContents cannot be null");
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        return this.baseRequest.getClient().getHttpProvider().send(this, this.baseRequest.getResponseType(), fileContents);
    }

    @Override
    @Nullable
    public URL getRequestUrl() {
        return this.baseRequest.getRequestUrl();
    }

    @Override
    @Nullable
    public HttpMethod getHttpMethod() {
        return this.baseRequest.getHttpMethod();
    }

    @Override
    public void addHeader(@Nonnull String header, @Nullable String value) {
        Objects.requireNonNull(header, "parameter header cannot be null");
        this.baseRequest.addHeader(header, value);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.baseRequest.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.baseRequest.getUseCaches();
    }

    @Override
    @Nullable
    public List<HeaderOption> getHeaders() {
        return this.baseRequest.getHeaders();
    }

    @Override
    @Nullable
    public List<Option> getOptions() {
        return this.baseRequest.getOptions();
    }

    @Override
    public void setMaxRedirects(int maxRedirects) {
        this.baseRequest.setMaxRedirects(maxRedirects);
    }

    @Override
    public int getMaxRedirects() {
        return this.baseRequest.getMaxRedirects();
    }

    @Override
    public void setShouldRedirect(@Nonnull IShouldRedirect shouldRedirect) {
        Objects.requireNonNull(shouldRedirect, "parameter shouldRedirect cannot be null");
        this.baseRequest.setShouldRedirect(shouldRedirect);
    }

    @Override
    @Nonnull
    public IShouldRedirect getShouldRedirect() {
        return this.baseRequest.getShouldRedirect();
    }

    @Override
    public void setShouldRetry(@Nonnull IShouldRetry shouldretry) {
        Objects.requireNonNull(shouldretry, "parameter shouldretry cannot be null");
        this.baseRequest.setShouldRetry(shouldretry);
    }

    @Override
    @Nonnull
    public IShouldRetry getShouldRetry() {
        return this.baseRequest.getShouldRetry();
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.baseRequest.setMaxRetries(maxRetries);
    }

    @Override
    public int getMaxRetries() {
        return this.baseRequest.getMaxRetries();
    }

    @Override
    public void setDelay(long delay) {
        this.baseRequest.setDelay(delay);
    }

    @Override
    public long getDelay() {
        return this.baseRequest.getDelay();
    }

    @Override
    @Nullable
    public IHttpRequest withHttpMethod(@Nonnull HttpMethod httpMethod) {
        Objects.requireNonNull(httpMethod, "parameter httpMethod cannot be null");
        this.baseRequest.setHttpMethod(httpMethod);
        return this;
    }

    @Override
    @Nullable
    public <requestBodyType, responseType, nativeRequestType> nativeRequestType getHttpRequest(@Nullable requestBodyType serializedObject) throws ClientException {
        return this.baseRequest.getHttpRequest(serializedObject);
    }
}

