/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentOperation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceDeployment
extends AbstractAzResource<ResourceDeployment, ResourceGroup, Deployment>
implements Deletable {
    private static final String EMPTY_PARAMETER = "{}";
    private static final String[] VALID_PARAMETER_ATTRIBUTES = new String[]{"value", "reference", "metadata"};

    protected ResourceDeployment(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ResourceDeploymentModule module) {
        super(name, resourceGroupName, module);
    }

    protected ResourceDeployment(@Nonnull ResourceDeployment origin) {
        super(origin);
    }

    protected ResourceDeployment(@Nonnull Deployment remote, @Nonnull ResourceDeploymentModule module) {
        super(remote.name(), remote.resourceGroupName(), module);
    }

    @Override
    @Nonnull
    protected Deployment refreshRemoteFromAzure(@Nonnull Deployment remote) {
        return (Deployment)((ResourceManager)remote.manager()).deployments().getById(remote.id());
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, ResourceDeployment, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    public String getMode() {
        return this.remoteOptional(new boolean[0]).map(Deployment::mode).orElse(DeploymentMode.INCREMENTAL).toString();
    }

    @Nullable
    public OffsetDateTime getTimestamp() {
        return this.remoteOptional(new boolean[0]).map(Deployment::timestamp).orElse(null);
    }

    @Nonnull
    public Stream<DeploymentOperation> getOperations() {
        return this.remoteOptional(new boolean[0]).map(d -> d.deploymentOperations().list().stream()).orElse(Stream.empty());
    }

    @Nonnull
    public List<String> getParameters() {
        return this.remoteOptional(new boolean[0]).map(r -> (Map)r.exportTemplate().template()).map(t -> (Map)t.get("parameters")).map(m -> m.entrySet().stream()).orElseGet(Stream::empty).map(p -> String.format("%s(%s)", p.getKey(), ((Map)p.getValue()).get("type"))).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getVariables() {
        return this.remoteOptional(new boolean[0]).map(r -> (Map)r.exportTemplate().template()).map(t -> (Map)t.get("variables")).map(m -> m.keySet().stream()).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getResources() {
        return this.remoteOptional(new boolean[0]).map(r -> (Map)r.exportTemplate().template()).map(t -> (List)t.get("resources")).map(Collection::stream).orElseGet(Stream::empty).map(r -> String.format("%s(%s)", r.get("name"), r.get("type"))).collect(Collectors.toList());
    }

    @Nullable
    public String getTemplateAsJson() {
        ObjectMapper mapper = new ObjectMapper();
        return this.remoteOptional(new boolean[0]).map(r -> r.exportTemplate().template()).map(t -> {
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(t);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }).orElse(null);
    }

    @Nullable
    public String getParametersAsJson() {
        ObjectMapper mapper = new ObjectMapper();
        Map parameters = this.remoteOptional(new boolean[0]).map(Deployment::parameters).filter(p -> p instanceof Map).orElse(null);
        if (Objects.nonNull(parameters)) {
            try {
                parameters.values().forEach(value -> {
                    Iterator iterator = value.entrySet().iterator();
                    while (iterator.hasNext()) {
                        String parameterKey = (String)iterator.next().getKey();
                        if (!Arrays.stream(VALID_PARAMETER_ATTRIBUTES).noneMatch(attribute -> attribute.equals(parameterKey))) continue;
                        iterator.remove();
                    }
                });
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)parameters);
            }
            catch (JsonProcessingException var2) {
                return EMPTY_PARAMETER;
            }
        }
        return EMPTY_PARAMETER;
    }

    @Override
    @Nonnull
    public String loadStatus(@Nonnull Deployment remote) {
        return remote.provisioningState();
    }
}

