/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Operation {
    public static final String UNKNOWN_NAME = "<unknown>.<unknown>";

    @Nonnull
    public String getExecutionId();

    @Nonnull
    public String getId();

    public Callable<?> getBody();

    @Nonnull
    public String getType();

    @Nullable
    public AzureString getDescription();

    public void setParent(Operation var1);

    @Nullable
    public Operation getParent();

    public OperationContext getContext();

    default public Operation getEffectiveParent() {
        Operation parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.getId().equals(UNKNOWN_NAME)) {
            return parent;
        }
        return parent.getEffectiveParent();
    }

    @Nullable
    default public Operation getActionParent() {
        if (this.getType().equals(AzureOperation.Type.ACTION.name())) {
            return this;
        }
        return Optional.ofNullable(this.getParent()).map(Operation::getActionParent).orElse(null);
    }

    @Nullable
    public static Operation current() {
        return OperationThreadContext.current().currentOperation();
    }
}

