/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function.impl;

import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotation;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotationClass;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionMethod;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandlerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionProject
extends FunctionProject {
    private static final Logger log = LoggerFactory.getLogger(DefaultFunctionProject.class);

    @Override
    public List<FunctionMethod> findAnnotatedMethods() {
        try {
            Set<Method> methods;
            try {
                log.debug("ClassPath to resolve: " + this.getTargetClassUrl());
                List<URL> dependencyWithTargetClass = this.getDependencyArtifactUrls();
                dependencyWithTargetClass.add(this.getTargetClassUrl());
                methods = DefaultFunctionProject.findFunctions(dependencyWithTargetClass);
            }
            catch (NoClassDefFoundError e) {
                log.debug("ClassPath to resolve: " + this.getArtifactUrl());
                methods = DefaultFunctionProject.findFunctions(Collections.singletonList(this.getArtifactUrl()));
            }
            return methods.stream().map(DefaultFunctionProject::create).collect(Collectors.toList());
        }
        catch (MalformedURLException e) {
            throw new AzureToolkitRuntimeException("Invalid URL when resolving functions in class path:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void installExtension(String funcPath) {
        CommandHandlerImpl commandHandler = new CommandHandlerImpl();
        FunctionCoreToolsHandler functionCoreToolsHandler = DefaultFunctionProject.getFunctionCoreToolsHandler(commandHandler);
        functionCoreToolsHandler.installExtension(this.getStagingFolder(), this.getBaseDirectory());
    }

    private static FunctionCoreToolsHandler getFunctionCoreToolsHandler(CommandHandler commandHandler) {
        return new FunctionCoreToolsHandlerImpl(commandHandler);
    }

    private URL getTargetClassUrl() throws MalformedURLException {
        return this.getClassesOutputDirectory().toURI().toURL();
    }

    private List<URL> getDependencyArtifactUrls() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        this.getDependencies().forEach(file -> {
            try {
                urlList.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.debug("Failed to get URL for file: " + file);
            }
        });
        return urlList;
    }

    private static Set<Method> findFunctions(List<URL> urls) {
        try {
            ClassLoader classLoader = DefaultFunctionProject.getClassLoader(urls);
            Class functionNameAnnotation = ClassUtils.getClass((ClassLoader)classLoader, (String)"com.microsoft.azure.functions.annotation.FunctionName");
            ConfigurationBuilder builder = new ConfigurationBuilder().addUrls(urls).setScanners(new Scanner[]{Scanners.MethodsAnnotated}).addClassLoaders(new ClassLoader[]{classLoader});
            return new Reflections((Configuration)builder).getMethodsAnnotatedWith(functionNameAnnotation);
        }
        catch (ClassNotFoundException e) {
            throw new AzureToolkitRuntimeException((Throwable)e);
        }
    }

    private static ClassLoader getClassLoader(List<URL> urlList) {
        URL[] urlArray = urlList.toArray(new URL[0]);
        return new URLClassLoader(urlArray, DefaultFunctionProject.class.getClassLoader());
    }

    private URL getArtifactUrl() throws MalformedURLException {
        return this.getArtifactFile().toURI().toURL();
    }

    public static FunctionAnnotation create(@Nonnull Annotation annotation) {
        return DefaultFunctionProject.create(annotation, true);
    }

    public static FunctionMethod create(Method method) {
        FunctionMethod functionMethod = new FunctionMethod();
        functionMethod.setName(method.getName());
        functionMethod.setReturnTypeName(method.getReturnType().getCanonicalName());
        functionMethod.setAnnotations(method.getAnnotations() == null ? Collections.emptyList() : Arrays.stream(method.getAnnotations()).map(DefaultFunctionProject::create).collect(Collectors.toList()));
        List<FunctionAnnotation[]> parameterAnnotations = Arrays.stream(method.getParameters()).map(Parameter::getAnnotations).filter(Objects::nonNull).map(a -> Arrays.stream(a).map(DefaultFunctionProject::create).collect(Collectors.toList()).toArray(new FunctionAnnotation[0])).collect(Collectors.toList());
        functionMethod.setParameterAnnotations(parameterAnnotations);
        functionMethod.setDeclaringTypeName(method.getDeclaringClass().getCanonicalName());
        return functionMethod;
    }

    private static FunctionAnnotation create(final @Nonnull Annotation annotation, boolean resolveAnnotationType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (Objects.equals(value, method.getDefaultValue())) {
                    defaultMap.put(method.getName(), value);
                    continue;
                }
                map.put(method.getName(), value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AzureToolkitRuntimeException(String.format("Cannot invoke method '%s' for annotation class '%s'", method.getName(), annotation.getClass().getSimpleName()), (Throwable)e);
            }
        }
        FunctionAnnotation functionAnnotation = new FunctionAnnotation(){

            @Override
            public boolean isAnnotationType(@Nonnull Class<? extends Annotation> clz) {
                return clz.isInstance(annotation);
            }
        };
        if (resolveAnnotationType) {
            functionAnnotation.setAnnotationClass(DefaultFunctionProject.toFunctionAnnotationClass(annotation.annotationType()));
        }
        functionAnnotation.setProperties(map);
        functionAnnotation.setDefaultProperties(defaultMap);
        return functionAnnotation;
    }

    private static FunctionAnnotationClass toFunctionAnnotationClass(Class<? extends Annotation> clz) {
        FunctionAnnotationClass type = new FunctionAnnotationClass();
        type.setFullName(clz.getCanonicalName());
        type.setName(clz.getSimpleName());
        type.setAnnotations(Arrays.stream(clz.getAnnotations()).map(a -> DefaultFunctionProject.create(a, false)).collect(Collectors.toList()));
        return type;
    }
}

