/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.mediaservices;

import com.microsoft.azure.spring.autoconfigure.mediaservices.MediaServicesProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.MediaConfiguration;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.MediaService;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

@org.springframework.context.annotation.Configuration
@ConditionalOnMissingBean(value={MediaContract.class})
@EnableConfigurationProperties(value={MediaServicesProperties.class})
@ConditionalOnProperty(prefix="azure.mediaservices", value={"account-name", "account-key"})
public class MediaServicesAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MediaServicesAutoConfiguration.class);
    private final MediaServicesProperties mediaServicesProperties;
    private final TelemetryProxy telemetryProxy;

    public MediaServicesAutoConfiguration(MediaServicesProperties mediaServicesProperties) {
        this.mediaServicesProperties = mediaServicesProperties;
        this.telemetryProxy = new TelemetryProxy(mediaServicesProperties.isAllowTelemetry());
    }

    @Bean
    public MediaContract mediaContract() throws ServiceException {
        LOG.debug("mediaContract called");
        this.trackCustomEvent();
        return this.createMediaContract();
    }

    private MediaContract createMediaContract() throws ServiceException {
        LOG.debug("createMediaContract called");
        Configuration configuration = MediaConfiguration.configureWithOAuthAuthentication((String)"https://media.windows.net/API/", (String)"https://wamsprodglobal001acs.accesscontrol.windows.net/v2/OAuth2-13", (String)this.mediaServicesProperties.getAccountName(), (String)this.mediaServicesProperties.getAccountKey(), (String)"urn:WindowsAzureMediaServices");
        if (Objects.nonNull(this.mediaServicesProperties.getProxyHost()) && Objects.nonNull(this.mediaServicesProperties.getProxyPort())) {
            configuration.getProperties().put("http.proxyHost", this.mediaServicesProperties.getProxyHost());
            configuration.getProperties().put("http.proxyPort", this.mediaServicesProperties.getProxyPort());
            configuration.getProperties().put("http.proxyScheme", this.mediaServicesProperties.getProxyScheme());
        } else {
            if (Objects.nonNull(this.mediaServicesProperties.getProxyHost()) && Objects.isNull(this.mediaServicesProperties.getProxyPort())) {
                throw new ServiceException("Please Set Network Proxy port in application.properties");
            }
            if (Objects.nonNull(this.mediaServicesProperties.getProxyPort()) && Objects.isNull(this.mediaServicesProperties.getProxyHost())) {
                throw new ServiceException("Please Set Network Proxy host in application.properties");
            }
        }
        return MediaService.create((Configuration)configuration);
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

