/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.aad.adal4j.UserAssertion;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.JacksonObjectMapperFactory;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpoints;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.naming.ServiceUnavailableException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AzureADGraphClient {
    private static final SimpleGrantedAuthority DEFAULT_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");
    private static final String DEFAULE_ROLE_PREFIX = "ROLE_";
    private static final String REQUEST_ID_SUFFIX = "aadfeed5";
    private String clientId;
    private String clientSecret;
    private List<String> aadTargetGroups;
    private ServiceEndpoints serviceEndpoints;

    public AzureADGraphClient(ClientCredential clientCredential, AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps) {
        this.clientId = clientCredential.getClientId();
        this.clientSecret = clientCredential.getClientSecret();
        this.aadTargetGroups = aadAuthProps.getActiveDirectoryGroups();
        this.serviceEndpoints = serviceEndpointsProps.getServiceEndpoints(aadAuthProps.getEnvironment());
    }

    private String getUserMembershipsV1(String accessToken) throws IOException {
        URL url = new URL(this.serviceEndpoints.getAadMembershipRestUri());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("api-version", "1.6");
        conn.setRequestProperty("Authorization", accessToken);
        conn.setRequestProperty("Accept", "application/json;odata=minimalmetadata");
        String responseInJson = AzureADGraphClient.getResponseStringFromConn(conn);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return responseInJson;
        }
        throw new IllegalStateException("Response is not 200, response json: " + responseInJson);
    }

    private static String getResponseStringFromConn(HttpURLConnection conn) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            StringBuilder stringBuffer = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }

    public List<UserGroup> getGroups(String graphApiToken) throws IOException {
        return this.loadUserGroups(graphApiToken);
    }

    private List<UserGroup> loadUserGroups(String graphApiToken) throws IOException {
        String responseInJson = this.getUserMembershipsV1(graphApiToken);
        ArrayList<UserGroup> lUserGroups = new ArrayList<UserGroup>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        JsonNode rootNode = (JsonNode)objectMapper.readValue(responseInJson, JsonNode.class);
        JsonNode valuesNode = rootNode.get("value");
        if (valuesNode != null) {
            valuesNode.forEach(valueNode -> {
                if (valueNode != null && valueNode.get("objectType").asText().equals("Group")) {
                    String objectID = valueNode.get("objectId").asText();
                    String displayName = valueNode.get("displayName").asText();
                    lUserGroups.add(new UserGroup(objectID, displayName));
                }
            });
        }
        return lUserGroups;
    }

    public Set<GrantedAuthority> getGrantedAuthorities(String graphApiToken) throws IOException {
        List<UserGroup> groups = this.getGroups(graphApiToken);
        return this.convertGroupsToGrantedAuthorities(groups);
    }

    public Set<GrantedAuthority> convertGroupsToGrantedAuthorities(List<UserGroup> groups) {
        Set mappedAuthorities = groups.stream().filter(group -> this.aadTargetGroups.contains(group.getDisplayName())).map(userGroup -> new SimpleGrantedAuthority(DEFAULE_ROLE_PREFIX + userGroup.getDisplayName())).collect(Collectors.toCollection(LinkedHashSet::new));
        if (mappedAuthorities.isEmpty()) {
            mappedAuthorities.add(DEFAULT_AUTHORITY);
        }
        return mappedAuthorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult acquireTokenForGraphApi(String idToken, String tenantId) throws MalformedURLException, ServiceUnavailableException, InterruptedException, ExecutionException {
        ClientCredential credential = new ClientCredential(this.clientId, this.clientSecret);
        UserAssertion assertion = new UserAssertion(idToken);
        AuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext(this.serviceEndpoints.getAadSigninUri() + tenantId + "/", true, service);
            context.setCorrelationId(AzureADGraphClient.getCorrelationId());
            Future future = context.acquireToken(this.serviceEndpoints.getAadGraphApiUri(), assertion, credential, null);
            result = (AuthenticationResult)future.get();
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new ServiceUnavailableException("unable to acquire on-behalf-of token for client " + this.clientId);
        }
        return result;
    }

    private static String getCorrelationId() {
        String uuid = UUID.randomUUID().toString();
        return uuid.substring(0, uuid.length() - REQUEST_ID_SUFFIX.length()) + REQUEST_ID_SUFFIX;
    }
}

