/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class SenderThreadLocalBackOffData {
    private final ReentrantLock lock;
    private final Condition backOffCondition;
    private int currentBackOffIndex;
    private boolean instanceIsActive;
    private final long addMilliseconds;
    private final long[] backOffTimeoutsInMillis;

    public SenderThreadLocalBackOffData(long[] backOffTimeoutsInMillis, long addMilliseconds) {
        Preconditions.checkNotNull(backOffTimeoutsInMillis, "backOffTimeoutsInMillis must be not null");
        Preconditions.checkArgument(backOffTimeoutsInMillis.length > 0, "backOffTimeoutsInMillis must not be empty");
        Preconditions.checkArgument(addMilliseconds >= 0L, "addMilliseconds must not be >= 0");
        this.currentBackOffIndex = -1;
        this.instanceIsActive = true;
        this.lock = new ReentrantLock();
        this.backOffCondition = this.lock.newCondition();
        this.backOffTimeoutsInMillis = backOffTimeoutsInMillis;
        this.addMilliseconds = addMilliseconds;
    }

    public boolean isTryingToSend() {
        return this.currentBackOffIndex != -1;
    }

    public void onDoneSending() {
        this.currentBackOffIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long backOffTimerValue() {
        try {
            this.lock.lock();
            this.currentBackOffIndex = Math.min(this.currentBackOffIndex + 1, this.backOffTimeoutsInMillis.length - 1);
            if (!this.instanceIsActive) {
                long l = 0L;
                return l;
            }
            long millisecondsToWait = this.backOffTimeoutsInMillis[this.currentBackOffIndex];
            if (millisecondsToWait > 5000L) {
                millisecondsToWait += this.addMilliseconds;
            }
            long l = millisecondsToWait;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        try {
            this.lock.lock();
            this.instanceIsActive = false;
            this.backOffCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

