/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.extensibility.initializer.docker.internal;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.initializer.docker.internal.DockerContext;
import com.microsoft.applicationinsights.extensibility.initializer.docker.internal.DockerContextFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.File;

public class DockerContextPoller
extends Thread {
    private static final String CONTEXT_FILE_NAME = "docker.info";
    private File contextFile;
    private DockerContextFactory dockerContextFactory;
    private volatile DockerContext dockerContext;
    protected int THREAD_POLLING_INTERVAL_MS = 2000;

    protected DockerContextPoller(File contextFile, DockerContextFactory dockerContextFactory) {
        this.contextFile = contextFile;
        this.dockerContextFactory = dockerContextFactory;
    }

    public DockerContextPoller(String contextFileDirectory) {
        this(new File(contextFileDirectory, CONTEXT_FILE_NAME), new DockerContextFactory());
        this.setDaemon(true);
        this.setName(DockerContextPoller.class.getSimpleName());
    }

    @Override
    public void run() {
        InternalLogger.INSTANCE.info("Starting to poll for Docker context file under: %s", this.contextFile.getAbsolutePath());
        boolean fileExists = false;
        while (!fileExists) {
            fileExists = this.contextFile.exists();
            if (fileExists) continue;
            try {
                Thread.sleep(this.THREAD_POLLING_INTERVAL_MS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        try {
            InternalLogger.INSTANCE.info("Docker context file has been found.", new Object[0]);
            this.dockerContext = this.dockerContextFactory.createDockerContext(this.contextFile);
            InternalLogger.INSTANCE.info("Docker context file has been deserialized successfully", new Object[0]);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Docker context file failed to be parsed with error: %s", e.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        InternalLogger.INSTANCE.info("Docker context poller finished polling for context file.", new Object[0]);
    }

    public boolean isCompleted() {
        return !this.isAlive();
    }

    public DockerContext getDockerContext() {
        return this.dockerContext;
    }
}

