/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.xstream.converters.extended;

import com.microsoft.applicationinsights.core.dependencies.xstream.converters.Converter;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.MarshallingContext;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.UnmarshallingContext;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamReader;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamWriter;
import java.awt.Color;
import java.util.HashMap;

public class ColorConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type != null && type.getName().equals("java.awt.Color");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Color color = (Color)source;
        this.write("red", color.getRed(), writer);
        this.write("green", color.getGreen(), writer);
        this.write("blue", color.getBlue(), writer);
        this.write("alpha", color.getAlpha(), writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, Integer> elements = new HashMap<String, Integer>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            elements.put(reader.getNodeName(), Integer.valueOf(reader.getValue()));
            reader.moveUp();
        }
        return new Color((Integer)elements.get("red"), (Integer)elements.get("green"), (Integer)elements.get("blue"), (Integer)elements.get("alpha"));
    }

    private void write(String fieldName, int value, HierarchicalStreamWriter writer) {
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, fieldName, Integer.TYPE);
        writer.setValue(String.valueOf(value));
        writer.endNode();
    }
}

