/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.extensibility.context.ContextTagKeys;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ContextTagsMap
implements ConcurrentMap<String, String> {
    private static final Map<String, Integer> tagSizeLimits = new HashMap<String, Integer>();
    private final ConcurrentMap<String, String> tags = new ConcurrentHashMap<String, String>();

    ContextTagsMap() {
    }

    private static String sanitizeKey(String key) {
        return key;
    }

    private static String truncate(String value, int maxLength) {
        if (value != null && value.length() > maxLength) {
            value = StringUtils.truncate(value, maxLength);
        }
        return value;
    }

    private String sanitizeValue(String key, String value) {
        value = StringUtils.trim(value);
        if (tagSizeLimits.containsKey(key)) {
            value = ContextTagsMap.truncate(value, tagSizeLimits.get(key));
        }
        return value;
    }

    @Override
    public String putIfAbsent(String key, String value) {
        return this.tags.putIfAbsent(key, this.sanitizeValue(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.tags.remove(key, value);
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        return this.tags.replace(key, oldValue, this.sanitizeValue(key, newValue));
    }

    @Override
    public String replace(String key, String value) {
        return this.tags.replace(key, this.sanitizeValue(key, value));
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tags.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.tags.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return (String)this.tags.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.tags.put(key, this.sanitizeValue(key, value));
    }

    @Override
    public String remove(Object key) {
        return (String)this.tags.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        HashMap<String, String> sanitized = new HashMap<String, String>();
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            sanitized.put(entry.getKey(), this.sanitizeValue(entry.getKey(), entry.getValue()));
        }
        this.tags.putAll(sanitized);
    }

    @Override
    public void clear() {
        this.tags.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.tags.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.tags.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.tags.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.tags.equals(o);
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }

    static {
        tagSizeLimits.put(ContextTagKeys.getKeys().getApplicationVersion(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getDeviceId(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getDeviceModel(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getDeviceOEMName(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getDeviceOSVersion(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getDeviceType(), 64);
        tagSizeLimits.put(ContextTagKeys.getKeys().getLocationIP(), 45);
        tagSizeLimits.put(ContextTagKeys.getKeys().getOperationId(), 128);
        tagSizeLimits.put(ContextTagKeys.getKeys().getOperationName(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getOperationParentId(), 128);
        tagSizeLimits.put(ContextTagKeys.getKeys().getSyntheticSource(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getSessionId(), 64);
        tagSizeLimits.put(ContextTagKeys.getKeys().getUserId(), 128);
        tagSizeLimits.put(ContextTagKeys.getKeys().getUserAccountId(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getUserAuthUserId(), 1024);
        tagSizeLimits.put(ContextTagKeys.getKeys().getCloudRole(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getCloudRoleInstance(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getInternalSdkVersion(), 64);
        tagSizeLimits.put(ContextTagKeys.getKeys().getInternalAgentVersion(), 64);
        tagSizeLimits.put(ContextTagKeys.getKeys().getInternalNodeName(), 256);
        tagSizeLimits.put(ContextTagKeys.getKeys().getOperationCorrelationVector(), 64);
    }
}

