/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.entity.ByteArrayEntity;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseNetworkHelper;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulsePingSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseStatus;
import java.io.IOException;
import java.util.Date;

final class DefaultQuickPulsePingSender
implements QuickPulsePingSender {
    private static final String QP_BASE_URI = "https://rt.services.visualstudio.com/QuickPulseService.svc";
    private final TelemetryConfiguration configuration;
    private final ApacheSender apacheSender;
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private String pingPrefix;
    private long lastValidTransmission = 0L;

    public DefaultQuickPulsePingSender(ApacheSender sender, TelemetryConfiguration configuration, String instanceName, String quickPulseId) {
        this.configuration = configuration;
        this.apacheSender = sender;
        this.pingPrefix = "{\"Documents\": null,\"Instance\":\"" + instanceName + "\",\"InstrumentationKey\": null,\"InvariantVersion\": 2,\"MachineName\":\"" + instanceName + "\",\"Metrics\": null,\"StreamId\": \"" + quickPulseId + "\",\"Timestamp\": \"\\/Date(";
        if (InternalLogger.INSTANCE.isTraceEnabled()) {
            InternalLogger.INSTANCE.trace("%s using endpoint %s", DefaultQuickPulsePingSender.class.getSimpleName(), this.getQuickPulseEndpoint());
        }
    }

    @Deprecated
    public DefaultQuickPulsePingSender(ApacheSender apacheSender, String instanceName, String quickPulseId) {
        this(apacheSender, null, instanceName, quickPulseId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuickPulseStatus ping() {
        Date currentDate = new Date();
        HttpPost request = this.networkHelper.buildRequest(currentDate, this.getQuickPulsePingUri());
        ByteArrayEntity pingEntity = this.buildPingEntity(currentDate.getTime());
        request.setEntity(pingEntity);
        long sendTime = System.nanoTime();
        HttpResponse response = null;
        try {
            response = this.apacheSender.sendPostRequest(request);
            if (this.networkHelper.isSuccess(response)) {
                QuickPulseStatus quickPulseResultStatus = this.networkHelper.getQuickPulseStatus(response);
                switch (quickPulseResultStatus) {
                    case QP_IS_OFF: 
                    case QP_IS_ON: {
                        this.lastValidTransmission = sendTime;
                        QuickPulseStatus quickPulseStatus = quickPulseResultStatus;
                        return quickPulseStatus;
                    }
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                this.apacheSender.dispose(response);
            }
        }
        return this.onPingError(sendTime);
    }

    @VisibleForTesting
    String getQuickPulsePingUri() {
        return this.getQuickPulseEndpoint() + "/ping?ikey=" + this.getInstrumentationKey();
    }

    private String getInstrumentationKey() {
        TelemetryConfiguration config = this.configuration == null ? TelemetryConfiguration.getActive() : this.configuration;
        return config.getInstrumentationKey();
    }

    private String getQuickPulseEndpoint() {
        if (this.configuration != null) {
            return this.configuration.getEndpointProvider().getLiveEndpointURL().toString();
        }
        return QP_BASE_URI;
    }

    private ByteArrayEntity buildPingEntity(long timeInMillis) {
        String sb = this.pingPrefix + timeInMillis + ")\\/\",\"Version\":\"2.2.0-738\"}";
        return new ByteArrayEntity(sb.getBytes());
    }

    private QuickPulseStatus onPingError(long sendTime) {
        double timeFromLastValidTransmission = (double)(sendTime - this.lastValidTransmission) / 1.0E9;
        if (timeFromLastValidTransmission >= 60.0) {
            return QuickPulseStatus.ERROR;
        }
        return QuickPulseStatus.QP_IS_OFF;
    }
}

