/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.HttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.CloseableHttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.config.RegistryBuilder;
import com.microsoft.applicationinsights.core.dependencies.http.conn.socket.PlainConnectionSocketFactory;
import com.microsoft.applicationinsights.core.dependencies.http.conn.ssl.SSLConnectionSocketFactory;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.CloseableHttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.HttpClients;
import com.microsoft.applicationinsights.core.dependencies.http.impl.conn.PoolingHttpClientConnectionManager;
import com.microsoft.applicationinsights.core.dependencies.http.ssl.SSLContexts;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.SSLOptionsUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

final class ApacheSender43
implements ApacheSender {
    private final AtomicReference<CloseableHttpClient> httpClientRef = new AtomicReference();

    static ApacheSender43 create() {
        final ApacheSender43 sender = new ApacheSender43();
        final String[] allowedProtocols = SSLOptionsUtil.getAllowedProtocols();
        Thread initThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("https", new SSLConnectionSocketFactory(SSLContexts.createDefault(), allowedProtocols, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.getSocketFactory())).build());
                cm.setMaxTotal(200);
                cm.setDefaultMaxPerRoute(20);
                sender.httpClientRef.compareAndSet(null, HttpClients.custom().setConnectionManager(cm).useSystemProperties().build());
                AtomicReference atomicReference = sender.httpClientRef;
                synchronized (atomicReference) {
                    sender.httpClientRef.notifyAll();
                }
            }
        }, ApacheSender43.class.getSimpleName() + "_initializer");
        initThread.setDaemon(true);
        initThread.start();
        return sender;
    }

    private ApacheSender43() {
    }

    @Override
    public HttpResponse sendPostRequest(HttpPost post) throws IOException {
        return this.getHttpClient().execute(post);
    }

    @Override
    public void dispose(HttpResponse response) {
        try {
            if (response != null) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to send or failed to close response, exception: %s", e.toString());
        }
    }

    @Override
    public void close() {
        try {
            ((CloseableHttpClient)this.getHttpClient()).close();
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to close http client, exception: %s", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        AtomicReference<CloseableHttpClient> atomicReference = this.httpClientRef;
        synchronized (atomicReference) {
            try {
                while (this.httpClientRef.get() == null) {
                    this.httpClientRef.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.httpClientRef.get();
    }

    @Override
    public void enhanceRequest(HttpPost request) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).build();
        request.setConfig(requestConfig);
    }
}

