/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.xstream.io.xml;

import com.microsoft.applicationinsights.core.dependencies.xmlpull.v1.XmlPullParser;
import com.microsoft.applicationinsights.core.dependencies.xmlpull.v1.XmlPullParserException;
import com.microsoft.applicationinsights.core.dependencies.xstream.core.util.XmlHeaderAwareReader;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamReader;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamWriter;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.StreamException;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.naming.NameCoder;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.xml.AbstractXmlDriver;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.xml.PrettyPrintWriter;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class AbstractXppDriver
extends AbstractXmlDriver {
    public AbstractXppDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public HierarchicalStreamReader createReader(Reader in) {
        try {
            return new XppReader(in, this.createParser(), this.getNameCoder());
        }
        catch (XmlPullParserException e) {
            throw new StreamException("Cannot create XmlPullParser", e);
        }
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

