/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class CpuPerformanceCounterCalculator {
    private final int numberOfCpus;
    private long prevUpTime;
    private long prevProcessCpuTime;
    private ObjectName osBean;

    public CpuPerformanceCounterCalculator() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.numberOfCpus = operatingSystemMXBean.getAvailableProcessors();
    }

    public double getProcessCpuUsage() {
        double processCpuUsage;
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            long upTime = runtimeMXBean.getUptime();
            long processCpuTime = this.getProcessCpuTime();
            if (this.prevUpTime > 0L && upTime > this.prevUpTime) {
                long elapsedCpu = processCpuTime - this.prevProcessCpuTime;
                long elapsedTime = upTime - this.prevUpTime;
                processCpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)this.numberOfCpus));
            } else {
                processCpuUsage = -1.0;
            }
            this.prevUpTime = upTime;
            this.prevProcessCpuTime = processCpuTime;
        }
        catch (Exception e) {
            processCpuUsage = -1.0;
            InternalLogger.INSTANCE.error("Error in getProcessCPUUsage", new Object[0]);
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        return processCpuUsage;
    }

    private long getProcessCpuTime() throws Exception {
        MBeanServer bsvr = ManagementFactory.getPlatformMBeanServer();
        if (this.osBean == null) {
            this.osBean = ObjectName.getInstance("java.lang:type=OperatingSystem");
        }
        return (Long)bsvr.getAttribute(this.osBean, "ProcessCpuTime");
    }
}

