/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.sampling;

import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.util.concurrent.AtomicDouble;
import com.microsoft.applicationinsights.internal.channel.sampling.SamplingScoreGenerator;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.EventTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.SupportSampling;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FixedRateTelemetrySampler
implements TelemetrySampler {
    private AtomicDouble samplingPercentage = new AtomicDouble(100.0);
    private HashSet<Class> excludeTypes = new HashSet();
    private HashSet<Class> includeTypes = new HashSet();
    private final HashMap<String, Class> allowedTypes = new HashMap();

    public FixedRateTelemetrySampler() {
        this.allowedTypes.put("Dependency", RemoteDependencyTelemetry.class);
        this.allowedTypes.put("Event", EventTelemetry.class);
        this.allowedTypes.put("Exception", ExceptionTelemetry.class);
        this.allowedTypes.put("PageView", PageViewTelemetry.class);
        this.allowedTypes.put("Request", RequestTelemetry.class);
        this.allowedTypes.put("Trace", TraceTelemetry.class);
    }

    @Override
    public Set<Class> getExcludeTypes() {
        return Collections.unmodifiableSet(this.excludeTypes);
    }

    @Override
    public void setExcludeTypes(String types) {
        this.excludeTypes = this.parseToSet(types, "ExcludeTypes");
    }

    @Override
    public Set<Class> getIncludeTypes() {
        return Collections.unmodifiableSet(this.includeTypes);
    }

    @Override
    public void setIncludeTypes(String types) {
        this.includeTypes = this.parseToSet(types, "IncludeTypes");
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage.get();
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        if (samplingPercentage != null) {
            this.samplingPercentage.set(samplingPercentage);
        }
        InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Setting sampling percentage to %s percent", this.samplingPercentage);
    }

    @Override
    public boolean isSampledIn(Telemetry telemetry) {
        Double currentSamplingPercentage = this.samplingPercentage.get();
        if (currentSamplingPercentage < 99.999999999999 && telemetry instanceof SupportSampling) {
            SupportSampling samplingSupportingTelemetry = (SupportSampling)((Object)telemetry);
            if (!this.excludeTypes.isEmpty() && this.excludeTypes.contains(telemetry.getClass())) {
                InternalLogger.INSTANCE.trace("Skip sampling since %s is excluded", telemetry.getClass());
            } else if (!this.includeTypes.isEmpty() && !this.includeTypes.contains(telemetry.getClass())) {
                InternalLogger.INSTANCE.trace("Skip sampling since %s is not included", telemetry.getClass());
            } else {
                double telemetrySamplingScore;
                Double testedPercentage = currentSamplingPercentage;
                if (samplingSupportingTelemetry.getSamplingPercentage() != null) {
                    testedPercentage = samplingSupportingTelemetry.getSamplingPercentage();
                }
                if ((telemetrySamplingScore = SamplingScoreGenerator.getSamplingScore(telemetry)) >= testedPercentage) {
                    InternalLogger.INSTANCE.trace("Sampled out %s", telemetry.getClass());
                    return false;
                }
                samplingSupportingTelemetry.setSamplingPercentage(testedPercentage);
            }
        }
        return true;
    }

    private HashSet<Class> parseToSet(String value, String prefix) {
        HashSet<Class> set = new HashSet<Class>();
        if (!LocalStringsUtils.isNullOrEmpty(value)) {
            List<String> types = Arrays.asList(value.split(","));
            for (String type : types) {
                if (LocalStringsUtils.isNullOrEmpty(type = type.trim())) continue;
                if (!this.allowedTypes.containsKey(type)) {
                    InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "%s contains illegal type %s, ignored", prefix, type);
                    continue;
                }
                set.add(this.allowedTypes.get(type));
            }
        }
        return set;
    }
}

