/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JFontChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class WindowsFontChooserUI
extends FontChooserUI {
    private JFontChooser chooser;
    private JPanel fontPanel;
    private JTextField fontField;
    private JList fontList;
    private JTextField fontEffectField;
    private JList fontEffectList;
    private JPanel fontSizePanel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JTextArea previewPanel;
    private JComboBox charSetCombo;
    private PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent component) {
        return new WindowsFontChooserUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.chooser = (JFontChooser)c;
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle(FontChooserUI.class.getName() + "RB");
        this.fontPanel = new JPanel((LayoutManager)new PercentLayout(1, 2));
        JLabel label = new JLabel(bundle.getString("FontChooserUI.fontLabel"));
        this.fontPanel.add(label);
        this.fontField = new JTextField(25);
        this.fontPanel.add(this.fontField);
        this.fontField.setEditable(false);
        this.fontList = new JList();
        this.fontPanel.add((Component)new JScrollPane(this.fontList), "*");
        label.setLabelFor(this.fontList);
        label.setDisplayedMnemonic(bundle.getString("FontChooserUI.fontLabel.mnemonic").charAt(0));
        this.fontList.setSelectionMode(0);
        String[] fontFamilies = this.chooser.getModel().getFontFamilies(null);
        this.fontList.setListData(fontFamilies);
        JPanel fontEffectPanel = new JPanel((LayoutManager)new PercentLayout(1, 2));
        label = new JLabel(bundle.getString("FontChooserUI.styleLabel"));
        fontEffectPanel.add(label);
        this.fontEffectField = new JTextField(10);
        fontEffectPanel.add(this.fontEffectField);
        this.fontEffectField.setEditable(false);
        this.fontEffectList = new JList();
        fontEffectPanel.add((Component)new JScrollPane(this.fontEffectList), "*");
        label.setLabelFor(this.fontEffectList);
        label.setDisplayedMnemonic(bundle.getString("FontChooserUI.styleLabel.mnemonic").charAt(0));
        this.fontEffectList.setSelectionMode(0);
        FontStyle[] fontStyles = new FontStyle[]{new FontStyle(0, bundle.getString("FontChooserUI.style.plain")), new FontStyle(1, bundle.getString("FontChooserUI.style.bold")), new FontStyle(2, bundle.getString("FontChooserUI.style.italic")), new FontStyle(3, bundle.getString("FontChooserUI.style.bolditalic"))};
        this.fontEffectList.setListData(fontStyles);
        this.fontSizePanel = new JPanel((LayoutManager)new PercentLayout(1, 2));
        label = new JLabel(bundle.getString("FontChooserUI.sizeLabel"));
        this.fontSizePanel.add(label);
        label.setDisplayedMnemonic(bundle.getString("FontChooserUI.sizeLabel.mnemonic").charAt(0));
        this.fontSizeField = new JTextField(5);
        this.fontSizePanel.add(this.fontSizeField);
        label.setLabelFor(this.fontSizeField);
        this.fontSizeList = new JList();
        this.fontSizePanel.add((Component)new JScrollPane(this.fontSizeList), "*");
        int[] defaultFontSizes = this.chooser.getModel().getDefaultSizes();
        String[] sizes = new String[defaultFontSizes.length];
        int c = sizes.length;
        for (int i = 0; i < c; ++i) {
            sizes[i] = String.valueOf(defaultFontSizes[i]);
        }
        this.fontSizeList.setPrototypeCellValue("012345");
        this.fontSizeList.setListData(sizes);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(2);
        this.chooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)LookAndFeelTweaks.createHorizontalPercentLayout());
        panel.add((Component)this.fontPanel, "*");
        panel.add(fontEffectPanel);
        panel.add(this.fontSizePanel);
        this.previewPanel = new JTextArea();
        this.previewPanel.setText(this.chooser.getModel().getPreviewMessage(null));
        JScrollPane scroll = new JScrollPane(this.previewPanel);
        JSplitPane split = new JSplitPane(0);
        split.setBorder(null);
        split.setTopComponent(panel);
        split.setBottomComponent(scroll);
        split.setDividerLocation(0.5);
        split.setOneTouchExpandable(true);
        this.chooser.add("Center", split);
        panel.setMinimumSize(new Dimension(0, 0));
        JPanel charSetPanel = new JPanel((LayoutManager)new PercentLayout(0, 2));
        label = new JLabel("CHARSET");
        label.setHorizontalAlignment(4);
        charSetPanel.add((Component)label, "*");
        this.charSetCombo = new JComboBox<String>(this.chooser.getModel().getCharSets());
        charSetPanel.add(this.charSetCombo);
    }

    protected void installListeners() {
        SelectedFontUpdater listener = new SelectedFontUpdater();
        this.fontList.addListSelectionListener(listener);
        this.fontEffectList.addListSelectionListener(listener);
        this.fontSizeList.addListSelectionListener(listener);
        this.fontSizeField.getDocument().addDocumentListener(listener);
        this.propertyListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener("selectedFont", this.propertyListener);
    }

    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.fontPanel);
        this.chooser.remove(this.fontSizePanel);
        super.uninstallUI(c);
    }

    public void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                WindowsFontChooserUI.this.updateDisplay();
            }
        };
    }

    private void updateDisplay() {
        Font selected = this.chooser.getSelectedFont();
        if (selected != null) {
            this.previewPanel.setFont(selected);
            this.fontList.setSelectedValue(selected.getName(), true);
            this.fontSizeField.setText(String.valueOf(selected.getSize()));
            this.fontSizeList.setSelectedValue(String.valueOf(selected.getSize()), true);
            FontStyle style = new FontStyle(selected.getStyle(), null);
            this.fontEffectList.setSelectedValue(style, true);
            style = (FontStyle)this.fontEffectList.getSelectedValue();
            this.fontEffectField.setText(style.toString());
        }
    }

    private void updateSelectedFont() {
        Font font;
        int fontSize;
        Font currentFont = this.chooser.getSelectedFont();
        String fontFamily = currentFont == null ? "SansSerif" : currentFont.getName();
        int n = fontSize = currentFont == null ? 11 : currentFont.getSize();
        if (this.fontList.getSelectedIndex() >= 0) {
            fontFamily = (String)this.fontList.getSelectedValue();
        }
        if (this.fontSizeField.getText().trim().length() > 0) {
            try {
                fontSize = Integer.parseInt(this.fontSizeField.getText().trim());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
        attributes.put(TextAttribute.SIZE, new Float(fontSize));
        attributes.put(TextAttribute.FAMILY, fontFamily);
        FontStyle style = (FontStyle)this.fontEffectList.getSelectedValue();
        if (style != null) {
            if (style.isBold()) {
                attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (style.isItalic()) {
                attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        }
        if (!(font = Font.getFont(attributes)).equals(currentFont)) {
            this.chooser.setSelectedFont(font);
            this.previewPanel.setFont(font);
        }
    }

    private static class FontStyle {
        String display;
        int value;

        public FontStyle(int value, String display) {
            this.value = value;
            this.display = display;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.display;
        }

        public boolean isBold() {
            return (this.value & 1) != 0;
        }

        public boolean isItalic() {
            return (this.value & 2) != 0;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return obj instanceof FontStyle && ((FontStyle)obj).value == this.value;
        }
    }

    private class SelectedFontUpdater
    implements ListSelectionListener,
    DocumentListener,
    ActionListener {
        private SelectedFontUpdater() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (WindowsFontChooserUI.this.fontList == e.getSource() && WindowsFontChooserUI.this.fontList.getSelectedValue() != null) {
                WindowsFontChooserUI.this.fontField.setText((String)WindowsFontChooserUI.this.fontList.getSelectedValue());
            }
            if (WindowsFontChooserUI.this.fontSizeList == e.getSource() && WindowsFontChooserUI.this.fontSizeList.getSelectedValue() != null) {
                WindowsFontChooserUI.this.fontSizeField.setText((String)WindowsFontChooserUI.this.fontSizeList.getSelectedValue());
            }
            WindowsFontChooserUI.this.updateSelectedFont();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void actionPerformed(ActionEvent e) {
            this.updateLater();
        }

        void updateLater() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowsFontChooserUI.this.updateSelectedFont();
                }
            });
        }
    }
}

