/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JFontChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class BasicFontChooserUI
extends FontChooserUI {
    private JFontChooser chooser;
    private JPanel fontPanel;
    private JTextField fontField;
    private JList fontList;
    private JPanel fontSizePanel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JCheckBox boldCheck;
    private JCheckBox italicCheck;
    private JTextArea previewPanel;
    private PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent component) {
        return new BasicFontChooserUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.chooser = (JFontChooser)c;
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle(FontChooserUI.class.getName() + "RB");
        this.fontPanel = new JPanel((LayoutManager)new PercentLayout(1, 2));
        JLabel label = new JLabel(bundle.getString("FontChooserUI.fontLabel"));
        this.fontPanel.add(label);
        this.fontField = new JTextField(25);
        this.fontPanel.add(this.fontField);
        this.fontField.setEditable(false);
        this.fontList = new JList();
        this.fontPanel.add((Component)new JScrollPane(this.fontList), "*");
        label.setLabelFor(this.fontList);
        label.setDisplayedMnemonic(bundle.getString("FontChooserUI.fontLabel.mnemonic").charAt(0));
        this.fontList.setVisibleRowCount(7);
        this.fontList.setSelectionMode(0);
        String[] fontFamilies = this.chooser.getModel().getFontFamilies(null);
        this.fontList.setListData(fontFamilies);
        this.fontSizePanel = new JPanel((LayoutManager)new PercentLayout(1, 2));
        label = new JLabel(bundle.getString("FontChooserUI.styleLabel"));
        this.fontSizePanel.add(label);
        this.boldCheck = new JCheckBox(bundle.getString("FontChooserUI.style.bold"));
        this.fontSizePanel.add(this.boldCheck);
        this.italicCheck = new JCheckBox(bundle.getString("FontChooserUI.style.italic"));
        this.fontSizePanel.add(this.italicCheck);
        this.boldCheck.setMnemonic(bundle.getString("FontChooserUI.style.bold.mnemonic").charAt(0));
        this.italicCheck.setMnemonic(bundle.getString("FontChooserUI.style.italic.mnemonic").charAt(0));
        label = new JLabel(bundle.getString("FontChooserUI.sizeLabel"));
        this.fontSizePanel.add(label);
        label.setDisplayedMnemonic(bundle.getString("FontChooserUI.sizeLabel.mnemonic").charAt(0));
        this.fontSizeField = new JTextField();
        this.fontSizePanel.add(this.fontSizeField);
        label.setLabelFor(this.fontSizeField);
        this.fontSizeList = new JList();
        this.fontSizePanel.add((Component)new JScrollPane(this.fontSizeList), "*");
        int[] defaultFontSizes = this.chooser.getModel().getDefaultSizes();
        String[] sizes = new String[defaultFontSizes.length];
        int c = sizes.length;
        for (int i = 0; i < c; ++i) {
            sizes[i] = String.valueOf(defaultFontSizes[i]);
        }
        this.fontSizeList.setListData(sizes);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(2);
        this.chooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)LookAndFeelTweaks.createHorizontalPercentLayout());
        panel.add((Component)this.fontPanel, "*");
        panel.add(this.fontSizePanel);
        this.chooser.add("Center", panel);
        this.previewPanel = new JTextArea();
        this.previewPanel.setPreferredSize(new Dimension(100, 40));
        this.previewPanel.setText(this.chooser.getModel().getPreviewMessage(null));
        JScrollPane scroll = new JScrollPane(this.previewPanel);
        this.chooser.add("South", scroll);
    }

    protected void installListeners() {
        SelectedFontUpdater listener = new SelectedFontUpdater();
        this.fontList.addListSelectionListener(listener);
        this.fontSizeList.addListSelectionListener(listener);
        this.fontSizeField.getDocument().addDocumentListener(listener);
        this.boldCheck.addActionListener(listener);
        this.italicCheck.addActionListener(listener);
        this.propertyListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener("selectedFont", this.propertyListener);
    }

    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.fontPanel);
        this.chooser.remove(this.fontSizePanel);
        super.uninstallUI(c);
    }

    public void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BasicFontChooserUI.this.updateDisplay();
            }
        };
    }

    private void updateDisplay() {
        Font selected = this.chooser.getSelectedFont();
        if (selected != null) {
            this.previewPanel.setFont(selected);
            this.fontList.setSelectedValue(selected.getName(), true);
            this.fontSizeField.setText(String.valueOf(selected.getSize()));
            this.fontSizeList.setSelectedValue(String.valueOf(selected.getSize()), true);
            this.boldCheck.setSelected(selected.isBold());
            this.italicCheck.setSelected(selected.isItalic());
        }
    }

    private void updateSelectedFont() {
        Font font;
        int fontSize;
        Font currentFont = this.chooser.getSelectedFont();
        String fontFamily = currentFont == null ? "SansSerif" : currentFont.getName();
        int n = fontSize = currentFont == null ? 11 : currentFont.getSize();
        if (this.fontList.getSelectedIndex() >= 0) {
            fontFamily = (String)this.fontList.getSelectedValue();
        }
        if (this.fontSizeField.getText().trim().length() > 0) {
            try {
                fontSize = Integer.parseInt(this.fontSizeField.getText().trim());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
        attributes.put(TextAttribute.SIZE, new Float(fontSize));
        attributes.put(TextAttribute.FAMILY, fontFamily);
        if (this.boldCheck.isSelected()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italicCheck.isSelected()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (!(font = Font.getFont(attributes)).equals(currentFont)) {
            this.chooser.setSelectedFont(font);
            this.previewPanel.setFont(font);
        }
    }

    private class SelectedFontUpdater
    implements ListSelectionListener,
    DocumentListener,
    ActionListener {
        private SelectedFontUpdater() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (BasicFontChooserUI.this.fontList == e.getSource() && BasicFontChooserUI.this.fontList.getSelectedValue() != null) {
                BasicFontChooserUI.this.fontField.setText((String)BasicFontChooserUI.this.fontList.getSelectedValue());
            }
            if (BasicFontChooserUI.this.fontSizeList == e.getSource() && BasicFontChooserUI.this.fontSizeList.getSelectedValue() != null) {
                BasicFontChooserUI.this.fontSizeField.setText((String)BasicFontChooserUI.this.fontSizeList.getSelectedValue());
            }
            BasicFontChooserUI.this.updateSelectedFont();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateLater();
        }

        public void actionPerformed(ActionEvent e) {
            this.updateLater();
        }

        void updateLater() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BasicFontChooserUI.this.updateSelectedFont();
                }
            });
        }
    }
}

