/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.FontChooserModel;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.GraphicsEnvironment;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.SortedMap;

public class DefaultFontChooserModel
implements FontChooserModel {
    public static final int[] DEFAULT_FONT_SIZES = new int[]{6, 8, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 32, 40, 48, 56, 64, 72};
    protected String[] fontFamilies;
    private String[] charSets;
    private int[] defaultFontSizes;
    private String previewMessage;

    public DefaultFontChooserModel() {
        ResourceBundle bundle = ResourceBundle.getBundle(FontChooserUI.class.getName() + "RB");
        this.setPreviewMessage(bundle.getString("FontChooserUI.previewText"));
        Object[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fontFamilies);
        this.setFontFamilies((String[])fontFamilies);
        SortedMap<String, Charset> map = Charset.availableCharsets();
        String[] charSets = new String[map.size()];
        int i = 0;
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            charSets[i] = iter.next();
            ++i;
        }
        this.setCharSets(charSets);
        this.setDefaultFontSizes(DEFAULT_FONT_SIZES);
    }

    public void setFontFamilies(String[] fontFamilies) {
        this.fontFamilies = fontFamilies;
    }

    public String[] getFontFamilies(String charSetName) {
        return this.fontFamilies;
    }

    public void setDefaultFontSizes(int[] defaultFontSizes) {
        this.defaultFontSizes = defaultFontSizes;
    }

    public int[] getDefaultSizes() {
        return this.defaultFontSizes;
    }

    public void setCharSets(String[] charSets) {
        this.charSets = charSets;
    }

    public String[] getCharSets() {
        return this.charSets;
    }

    public void setPreviewMessage(String previewMessage) {
        this.previewMessage = previewMessage;
    }

    public String getPreviewMessage(String charSetName) {
        return this.previewMessage;
    }
}

