/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: QueryParameters.java 1821 2010-12-13 17:56:14Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-services/src/main/java/com/jurismarches/vradi/beans/QueryParameters.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.jurismarches.vradi.entities.Thesaurus;
import org.nuiton.wikitty.entities.WikittyExtension;

/**
 * Query parameters.
 * 
 * The {@link #beginDate} and {@link #endDate} specifies a
 * date range filter which is applied on {@link #dateFieldName} field.
 * The date range filter is applied only if the three parameters are not null.
 * 
 * @author chatellier
 * @version $Revision: 1821 $
 * 
 * Last update : $Date: 2010-12-13 18:56:14 +0100 (lun., 13 déc. 2010) $
 * By : $Author: sletellier $
 */
public class QueryParameters implements Serializable {

    /** serialVersionUID */
    private static final long serialVersionUID = 1L;

    protected String query;

    protected Date beginDate;

    protected Date endDate;

    protected WikittyExtension extension;

    protected String dateFieldName;

    protected List<String> statusIds;

    protected List<Thesaurus> thesaurus;

    protected List<String> streamIds;

    public QueryParameters() {
        
    }

    public QueryParameters(String query) {
        this();
        this.query = query;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public WikittyExtension getExtension() {
        return extension;
    }

    public void setExtension(WikittyExtension extension) {
        this.extension = extension;
    }

    public String getDateFieldName() {
        return dateFieldName;
    }

    public void setDateFieldName(String dateFieldName) {
        this.dateFieldName = dateFieldName;
    }

    public List<String> getStatusIds() {
        return statusIds;
    }

    public void setStatusIds(List<String> statusIds) {
        this.statusIds = statusIds;
    }

    public List<Thesaurus> getThesaurus() {
        return thesaurus;
    }

    public void setThesaurus(List<Thesaurus> thesaurus) {
        this.thesaurus = thesaurus;
    }

    public void addThesaurus(Thesaurus thesaurus) {
        if (this.thesaurus == null) {
            this.thesaurus = new ArrayList<Thesaurus>();
        }
        this.thesaurus.add(thesaurus);
    }

    public void clearThesaurus() {
        if (thesaurus != null) {
            this.thesaurus.clear();
        }
    }

    public List<String> getStreamIds() {
        return streamIds;
    }

    public void setStreamIds(List<String> streamIds) {
        this.streamIds = streamIds;
    }
}
