/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.util.logging.LogNoi18n;

public class LogNoi18nImpl
implements LogNoi18n {
    private final LogInterface m_logInterface;
    private final long m_debugLevel;
    private final long m_visLevel;
    private final long m_facLevel;

    public LogNoi18nImpl(LogInterface logInterface, long dl, long vl, long fl) {
        this.m_logInterface = logInterface;
        this.m_debugLevel = dl;
        this.m_visLevel = vl;
        this.m_facLevel = fl;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugAllowed(-1L, -1L, -1L);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_logInterface.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_logInterface.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_logInterface.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_logInterface.isFatalEnabled();
    }

    private boolean debugAllowed(long dLevel, long vLevel, long fLevel) {
        return (dLevel & this.m_debugLevel) != 0L && (vLevel & this.m_visLevel) != 0L && (fLevel & this.m_facLevel) != 0L && this.m_logInterface.isDebugEnabled();
    }

    @Override
    public void debug(long dl, long vl, long fl, String message) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(message);
        }
    }

    private void debug(String message) {
        this.m_logInterface.debug(message);
    }

    @Override
    public void info(Throwable message) {
        this.m_logInterface.info(message.toString(), message);
    }

    @Override
    public void warn(Throwable message) {
        this.m_logInterface.warn(message.toString(), message);
    }

    @Override
    public void error(Throwable message) {
        this.m_logInterface.error(message.toString(), message);
    }

    @Override
    public void fatal(Throwable message) {
        this.m_logInterface.fatal(message.toString(), message);
    }
}

