/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.XQueryDef;
import org.webharvest.definition.XQueryExternalParamDef;
import org.webharvest.exception.ScraperXQueryException;
import org.webharvest.runtime.RuntimeConfig;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.KeyValuePair;
import org.webharvest.utils.XmlUtil;

public class XQueryProcessor
extends BaseProcessor {
    public static Set ALLOWED_PARAM_TYPES = new TreeSet();
    public static String DEFAULT_PARAM_TYPE = "node()";
    private XQueryDef xqueryDef;

    public XQueryProcessor(XQueryDef xqueryDef) {
        super(xqueryDef);
        this.xqueryDef = xqueryDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        BaseElementDef xqueryElementDef = this.xqueryDef.getXqDef();
        Variable xq = this.getBodyTextContent(xqueryElementDef, scraper, context, true);
        this.debug(xqueryElementDef, scraper, xq);
        String xqExpression = xq.toString().trim();
        XQueryExternalParamDef[] externalParamDefs = this.xqueryDef.getExternalParamDefs();
        RuntimeConfig runtimeConfig = scraper.getRuntimeConfig();
        StaticQueryContext sqc = runtimeConfig.getStaticQueryContext();
        Configuration config = sqc.getConfiguration();
        try {
            XQueryExpression exp = runtimeConfig.getXQueryExpressionPool().getCompiledExpression(xqExpression);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(config);
            for (int i = 0; i < externalParamDefs.length; ++i) {
                XQueryExternalParamDef externalParamDef = externalParamDefs[i];
                String externalParamName = BaseTemplater.execute(externalParamDef.getName(), scraper.getScriptEngine());
                String externalParamType = BaseTemplater.execute(externalParamDefs[i].getType(), scraper.getScriptEngine());
                if (externalParamType == null) {
                    externalParamType = DEFAULT_PARAM_TYPE;
                }
                if (!ALLOWED_PARAM_TYPES.contains(externalParamType)) {
                    throw new ScraperXQueryException("Type " + externalParamType + " is not allowed. Use one of " + ALLOWED_PARAM_TYPES.toString());
                }
                if (externalParamType.endsWith("*")) {
                    BodyProcessor bodyProcessor = new BodyProcessor(externalParamDef);
                    bodyProcessor.setProperty("Name", externalParamName);
                    bodyProcessor.setProperty("Type", externalParamType);
                    ListVariable listVar = (ListVariable)bodyProcessor.run(scraper, context);
                    this.debug(externalParamDef, scraper, listVar);
                    Iterator it = listVar.toList().iterator();
                    ArrayList<Object> paramList = new ArrayList<Object>();
                    while (it.hasNext()) {
                        Variable currVar = (Variable)it.next();
                        paramList.add(this.castSimpleValue(externalParamType, currVar, sqc));
                    }
                    dynamicContext.setParameter(externalParamName, paramList);
                    continue;
                }
                KeyValuePair[] props = new KeyValuePair[]{new KeyValuePair<String>("Name", externalParamName), new KeyValuePair<String>("Type", externalParamType)};
                Variable var = this.getBodyTextContent(externalParamDef, scraper, context, true, props);
                this.debug(externalParamDef, scraper, var);
                Object value = this.castSimpleValue(externalParamType, var, sqc);
                dynamicContext.setParameter(externalParamName, value);
            }
            return XmlUtil.createListOfXmlNodes(exp, dynamicContext);
        }
        catch (XPathException e) {
            throw new ScraperXQueryException("Error executing XQuery expression (XQuery = [" + xqExpression + "])!", e);
        }
    }

    private Object castSimpleValue(String type, Variable value, StaticQueryContext sqc) throws XPathException {
        if ((type = type.toLowerCase()).startsWith("node()")) {
            StringReader reader = new StringReader(value.toString());
            return sqc.buildDocument((Source)new StreamSource(reader));
        }
        if (type.startsWith("integer")) {
            return new Integer(value.toString().trim());
        }
        if (type.startsWith("long")) {
            return new Long(value.toString().trim());
        }
        if (type.startsWith("float")) {
            return new Float(value.toString().trim());
        }
        if (type.startsWith("double")) {
            return new Double(value.toString().trim());
        }
        if (type.startsWith("boolean")) {
            return CommonUtil.isBooleanTrue(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return value.toString();
    }

    static {
        ALLOWED_PARAM_TYPES.add("node()");
        ALLOWED_PARAM_TYPES.add("node()*");
        ALLOWED_PARAM_TYPES.add("integer");
        ALLOWED_PARAM_TYPES.add("integer*");
        ALLOWED_PARAM_TYPES.add("long");
        ALLOWED_PARAM_TYPES.add("long*");
        ALLOWED_PARAM_TYPES.add("float");
        ALLOWED_PARAM_TYPES.add("float*");
        ALLOWED_PARAM_TYPES.add("double");
        ALLOWED_PARAM_TYPES.add("double*");
        ALLOWED_PARAM_TYPES.add("boolean");
        ALLOWED_PARAM_TYPES.add("boolean*");
        ALLOWED_PARAM_TYPES.add("string");
        ALLOWED_PARAM_TYPES.add("string*");
    }
}

