/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class Closure
extends GroovyObjectSupport
implements Cloneable,
Runnable {
    private static final Object[] noParameters = new Object[]{null};
    private static final Object[] emptyArray = new Object[0];
    private static final Object[] emptyArrayParameter = new Object[]{emptyArray};
    private Object delegate;
    private final Object owner;
    private Class[] parameterTypes;
    protected int maximumNumberOfParameters;
    private int directive = 0;
    public static final int DONE = 1;
    public static final int SKIP = 2;

    public Closure(Object owner) {
        this.owner = owner;
        this.delegate = owner;
        Class<?> closureClass = this.getClass();
        this.maximumNumberOfParameters = 0;
        final Class<?> clazz = closureClass;
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        });
        for (int j = 0; j < methods.length; ++j) {
            if (!"doCall".equals(methods[j].getName()) || methods[j].getParameterTypes().length <= this.maximumNumberOfParameters) continue;
            this.parameterTypes = methods[j].getParameterTypes();
            this.maximumNumberOfParameters = this.parameterTypes.length;
        }
    }

    public Object getProperty(String property) {
        if ("delegate".equals(property)) {
            return this.getDelegate();
        }
        if ("owner".equals(property)) {
            return this.getOwner();
        }
        if ("getMaximumNumberOfParameters".equals(property)) {
            return new Integer(this.getMaximumNumberOfParameters());
        }
        if ("parameterTypes".equals(property)) {
            return this.getParameterTypes();
        }
        if ("metaClass".equals(property)) {
            return this.getMetaClass();
        }
        if ("class".equals(property)) {
            return this.getClass();
        }
        try {
            return InvokerHelper.getProperty(this.owner, property);
        }
        catch (GroovyRuntimeException e1) {
            if (this.delegate != null && this.delegate != this && this.delegate != this.owner) {
                try {
                    return InvokerHelper.getProperty(this.delegate, property);
                }
                catch (GroovyRuntimeException groovyRuntimeException) {
                    // empty catch block
                }
            }
            throw e1;
        }
    }

    public void setProperty(String property, Object newValue) {
        if ("delegate".equals(property)) {
            this.setDelegate(newValue);
        } else if ("metaClass".equals(property)) {
            this.setMetaClass((MetaClass)newValue);
        } else {
            try {
                InvokerHelper.setProperty(this.owner, property, newValue);
                return;
            }
            catch (GroovyRuntimeException e1) {
                if (this.delegate != null && this.delegate != this && this.delegate != this.owner) {
                    try {
                        InvokerHelper.setProperty(this.delegate, property, newValue);
                        return;
                    }
                    catch (GroovyRuntimeException e2) {
                        // empty catch block
                    }
                }
                throw e1;
            }
        }
    }

    public boolean isCase(Object candidate) {
        return InvokerHelper.asBool(this.call(candidate));
    }

    public Object call() {
        return this.call(new Object[0]);
    }

    public Object call(Object[] args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, "doCall", args);
        }
        catch (Exception e) {
            return Closure.throwRuntimeException(e);
        }
    }

    public Object call(Object arguments) {
        return this.call(new Object[]{arguments});
    }

    protected static Object throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new GroovyRuntimeException(throwable.getMessage(), throwable);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getMaximumNumberOfParameters() {
        return this.maximumNumberOfParameters;
    }

    public Closure asWritable() {
        return new WritableClosure();
    }

    public void run() {
        this.call();
    }

    public Closure curry(Object[] arguments) {
        return new CurriedClosure(this, arguments);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getDirective() {
        return this.directive;
    }

    public void setDirective(int directive) {
        this.directive = directive;
    }

    private class WritableClosure
    extends Closure
    implements Writable {
        public WritableClosure() {
            super(Closure.this);
        }

        public Writer writeTo(Writer out) throws IOException {
            Closure.this.call(new Object[]{out});
            return out;
        }

        public Object invokeMethod(String method, Object arguments) {
            if ("clone".equals(method)) {
                return this.clone();
            }
            if ("curry".equals(method)) {
                return this.curry((Object[])arguments);
            }
            if ("asWritable".equals(method)) {
                return this.asWritable();
            }
            return Closure.this.invokeMethod(method, arguments);
        }

        public Object getProperty(String property) {
            return Closure.this.getProperty(property);
        }

        public void setProperty(String property, Object newValue) {
            Closure.this.setProperty(property, newValue);
        }

        public Object call() {
            return Closure.this.call();
        }

        public Object call(Object arguments) {
            return Closure.this.call(arguments);
        }

        public Object getDelegate() {
            return Closure.this.getDelegate();
        }

        public void setDelegate(Object delegate) {
            Closure.this.setDelegate(delegate);
        }

        public Class[] getParameterTypes() {
            return Closure.this.getParameterTypes();
        }

        public int getMaximumNumberOfParameters() {
            return Closure.this.getMaximumNumberOfParameters();
        }

        public Closure asWritable() {
            return this;
        }

        public void run() {
            Closure.this.run();
        }

        public Object clone() {
            return ((Closure)Closure.this.clone()).asWritable();
        }

        public int hashCode() {
            return Closure.this.hashCode();
        }

        public boolean equals(Object arg0) {
            return Closure.this.equals(arg0);
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            try {
                this.writeTo(writer);
            }
            catch (IOException e) {
                return null;
            }
            return writer.toString();
        }

        public Closure curry(Object[] arguments) {
            return new CurriedClosure(this, arguments).asWritable();
        }
    }
}

