/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiStorageService;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyService;

public class MiscServicesTest {
    private static final Log log = LogFactory.getLog(MiscServicesTest.class);

    protected boolean isValidServiceType(Class<?> clazz) {
        boolean result = false;
        if (clazz.isInterface() || clazz.isPrimitive()) {
            result = true;
        } else if (Serializable.class.isAssignableFrom(clazz)) {
            result = true;
        }
        if (clazz.getName().equals("java.io.File")) {
            result = false;
        }
        if (clazz.getName().equals("org.nuiton.wikitty.WikittyTransaction")) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Warning : method parameter " + clazz.getName() + " is only tolerated (can't be used) !"));
            }
            result = true;
        }
        return result;
    }

    @Test
    public void testSerializableParamsAndReturnForService() {
        Class[] classesToTest;
        boolean foundNotSerializable = false;
        for (Class clazz : classesToTest = new Class[]{VradiDataService.class, VradiStorageService.class, WikittyService.class}) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Class<?>[] parameters;
                for (Class<?> parameter : parameters = method.getParameterTypes()) {
                    if (this.isValidServiceType(parameter)) continue;
                    if (log.isErrorEnabled()) {
                        log.error((Object)(clazz.getSimpleName() + "#" + method.getName() + " uses a non allowed parameter type : " + parameter.getCanonicalName()));
                    }
                    foundNotSerializable = true;
                }
                Class<?> returnType = method.getReturnType();
                if (this.isValidServiceType(returnType)) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)(clazz.getSimpleName() + "#" + method.getName() + " uses a non allowed return type : " + returnType.getCanonicalName()));
                }
                foundNotSerializable = true;
            }
        }
        Assert.assertFalse((String)"A service class uses not serializable stuff !", (boolean)foundNotSerializable);
    }
}

