/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FilterList.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-services/src/main/java/com/jurismarches/vradi/services/search/FilterList.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.search;

import java.util.ArrayList;
import java.util.List;

import org.apache.lucene.search.BooleanClause;

/**
 * <code>FilterList</code> is an union of <code>Filters</code>
 * which must obey the same <code>FilterList.Operator</code>.
 * 
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 0.0.4
 */
public class FilterList implements Filter {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected Operator operator;

    protected List<Filter> filters;

    public static enum Operator {
        /** And. */
        FILTER_AND,
        /** Or. */
        FILTER_OR,
        /** Not. */
        FILTER_NOT;
        
        /**
         * Find operator corresponding to lucene {@link BooleanClause}
         * definition.
         * 
         * @param booleanClause boolean clause to inspect
         * @return operator to use
         */
        public static Operator getOperator(BooleanClause booleanClause) {
            Operator operator = null;
            
            if (booleanClause != null && booleanClause.isProhibited()) {
                operator = FILTER_NOT;
                
            } else if (booleanClause != null && booleanClause.isRequired()) {
                operator = FILTER_AND;
                
            } else {
                operator = FILTER_OR;
            }

            return operator;
        }

        /**
         * Return lucene operator String value used to recompose decomposed query.
         * 
         * @return lucene operator value
         */
        public String getValue() {
            String luceneOperator = null;
            switch(this) {
                case FILTER_NOT: 
                    luceneOperator = "NOT";
                    break;
                case FILTER_AND: 
                    luceneOperator = "AND";
                    break;
                case FILTER_OR: 
                    luceneOperator = "OR";
                    break;
            }
            return luceneOperator;
        }
    }

    public FilterList() {
        this(Operator.FILTER_AND);
    }

    public FilterList(Operator operator) {
        this.operator = operator;
        this.filters = new ArrayList<Filter>();
    }

    public Operator getOperator() {
        return operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }
    
    public List<Filter> getFilters() {
        return filters;
    }

    public boolean addFilter(Filter filter) {
        return filters.add(filter);
    }

}
