/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import org.webharvest.definition.CallDef;
import org.webharvest.definition.FunctionDef;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.exception.FunctionException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;

public class CallProcessor
extends BaseProcessor {
    private CallDef callDef;
    ScraperContext functionContext;
    ScriptEngine scriptEngine;
    private Variable functionResult = new NodeVariable("");

    public CallProcessor(CallDef callDef, ScraperConfiguration configuration, Scraper scraper) {
        super(callDef);
        CallProcessor runningFunction = scraper.getRunningFunction();
        ScraperContext callerContext = runningFunction == null ? scraper.getContext() : runningFunction.getFunctionContext();
        this.functionContext = new ScraperContext(scraper, callerContext);
        this.scriptEngine = configuration.createScriptEngine(this.functionContext);
        this.callDef = callDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        String functionName = BaseTemplater.execute(this.callDef.getName(), scraper.getScriptEngine());
        FunctionDef functionDef = scraper.getConfiguration().getFunctionDef(functionName);
        this.setProperty("Name", functionName);
        if (functionDef == null) {
            throw new FunctionException("Function \"" + functionName + "\" is undefined!");
        }
        scraper.clearFunctionParams();
        new BodyProcessor(this.callDef).execute(scraper, context);
        this.functionContext.putAll(scraper.getFunctionParams());
        scraper.addRunningFunction(this);
        new BodyProcessor(functionDef).execute(scraper, this.functionContext);
        scraper.removeRunningFunction();
        return this.functionResult;
    }

    public void setFunctionResult(Variable result) {
        this.functionResult = result;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public ScraperContext getFunctionContext() {
        return this.functionContext;
    }
}

