/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.TimeScheduler;

public class DefaultRetransmitter
extends Retransmitter {
    private final ConcurrentMap<Long, Retransmitter.Task> msgs = new ConcurrentHashMap<Long, Retransmitter.Task>(11);

    public DefaultRetransmitter(Address sender, Retransmitter.RetransmitCommand cmd, TimeScheduler sched) {
        super(sender, cmd, sched);
    }

    @Override
    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        for (long seqno = first_seqno; seqno <= last_seqno; ++seqno) {
            SeqnoTask new_task = new SeqnoTask(seqno, this.RETRANSMIT_TIMEOUTS.copy(), this.cmd, this.sender);
            Retransmitter.Task old_task = this.msgs.putIfAbsent(seqno, new_task);
            if (old_task != null) continue;
            new_task.doSchedule();
        }
    }

    @Override
    public int remove(long seqno) {
        Retransmitter.Task task = (Retransmitter.Task)this.msgs.remove(seqno);
        if (task != null) {
            task.cancel();
            return task.getNumRetransmits();
        }
        return -1;
    }

    @Override
    public void reset() {
        for (Retransmitter.Task task : this.msgs.values()) {
            task.cancel();
        }
        this.msgs.clear();
    }

    public String toString() {
        Set keys = this.msgs.keySet();
        int size = keys.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size).append(" messages to retransmit");
        if (size < 50) {
            sb.append(": ").append(keys);
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.msgs.size();
    }

    protected class SeqnoTask
    extends Retransmitter.Task {
        private long seqno;

        protected SeqnoTask(long seqno, Interval intervals, Retransmitter.RetransmitCommand cmd, Address msg_sender) {
            super(DefaultRetransmitter.this, intervals, cmd, msg_sender);
            this.seqno = -1L;
            this.seqno = seqno;
        }

        public String toString() {
            return String.valueOf(this.seqno);
        }

        @Override
        protected void callRetransmissionCommand() {
            this.command.retransmit(this.seqno, this.seqno, this.msg_sender);
        }
    }
}

