/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSCommand;
import org.apache.commons.net.ftp.FTPSServerSocketFactory;
import org.apache.commons.net.ftp.FTPSSocketFactory;
import org.apache.commons.net.ftp.FTPSTrustManager;

public class FTPSClient
extends FTPClient {
    private static final String[] PROT_COMMAND_VALUE = new String[]{"C", "E", "S", "P"};
    private static final String DEFAULT_PROT = "C";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final boolean isImplicit;
    private final String protocol;
    private String auth = "TLS";
    private SSLContext context;
    private Socket plainSocket;
    private boolean isCreation = true;
    private boolean isClientMode = true;
    private boolean isNeedClientAuth = false;
    private boolean isWantClientAuth = false;
    private String[] suites = null;
    private String[] protocols = null;
    private TrustManager trustManager = new FTPSTrustManager();
    private KeyManager keyManager;

    public FTPSClient() throws NoSuchAlgorithmException {
        this.protocol = DEFAULT_PROTOCOL;
        this.isImplicit = false;
    }

    public FTPSClient(boolean isImplicit) throws NoSuchAlgorithmException {
        this.protocol = DEFAULT_PROTOCOL;
        this.isImplicit = isImplicit;
    }

    public FTPSClient(String protocol) throws NoSuchAlgorithmException {
        this.protocol = protocol;
        this.isImplicit = false;
    }

    public FTPSClient(String protocol, boolean isImplicit) throws NoSuchAlgorithmException {
        this.protocol = protocol;
        this.isImplicit = isImplicit;
    }

    public FTPSClient(boolean isImplicit, SSLContext context) {
        this.isImplicit = isImplicit;
        this.context = context;
        this.protocol = DEFAULT_PROTOCOL;
    }

    public FTPSClient(SSLContext context) {
        this(false, context);
    }

    public void setAuthValue(String auth) {
        this.auth = auth;
    }

    public String getAuthValue() {
        return this.auth;
    }

    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.sslNegotiation();
        }
        super._connectAction_();
        if (!this.isImplicit) {
            this.execAUTH();
            this.sslNegotiation();
        }
    }

    private void execAUTH() throws SSLException, IOException {
        int replyCode = this.sendCommand(FTPSCommand._commands[0], this.auth);
        if (334 != replyCode && 234 != replyCode) {
            throw new SSLException(this.getReplyString());
        }
    }

    private void initSslContext() throws IOException {
        if (this.context == null) {
            try {
                this.context = SSLContext.getInstance(this.protocol);
                this.context.init(new KeyManager[]{this.getKeyManager()}, new TrustManager[]{this.getTrustManager()}, null);
            }
            catch (KeyManagementException e) {
                IOException ioe = new IOException("Could not initialize SSL context");
                ioe.initCause(e);
                throw ioe;
            }
            catch (NoSuchAlgorithmException e) {
                IOException ioe = new IOException("Could not initialize SSL context");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void sslNegotiation() throws IOException {
        this.plainSocket = this._socket_;
        this.initSslContext();
        SSLSocketFactory ssf = this.context.getSocketFactory();
        String ip = this._socket_.getInetAddress().getHostAddress();
        int port = this._socket_.getPort();
        SSLSocket socket = (SSLSocket)ssf.createSocket(this._socket_, ip, port, true);
        socket.setEnableSessionCreation(this.isCreation);
        socket.setUseClientMode(this.isClientMode);
        if (!this.isClientMode) {
            socket.setNeedClientAuth(this.isNeedClientAuth);
            socket.setWantClientAuth(this.isWantClientAuth);
        }
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            socket.setEnabledCipherSuites(this.suites);
        }
        socket.startHandshake();
        this._socket_ = socket;
        this._controlInput_ = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.getControlEncoding()));
    }

    private KeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setEnabledSessionCreation(boolean isCreation) {
        this.isCreation = isCreation;
    }

    public boolean getEnableSessionCreation() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnableSessionCreation();
        }
        return false;
    }

    public void setNeedClientAuth(boolean isNeedClientAuth) {
        this.isNeedClientAuth = isNeedClientAuth;
    }

    public boolean getNeedClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getNeedClientAuth();
        }
        return false;
    }

    public void setWantClientAuth(boolean isWantClientAuth) {
        this.isWantClientAuth = isWantClientAuth;
    }

    public boolean getWantClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getWantClientAuth();
        }
        return false;
    }

    public void setUseClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public boolean getUseClientMode() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getUseClientMode();
        }
        return false;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.suites = new String[cipherSuites.length];
        System.arraycopy(cipherSuites, 0, this.suites, 0, cipherSuites.length);
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public void setEnabledProtocols(String[] protocolVersions) {
        this.protocols = new String[protocolVersions.length];
        System.arraycopy(protocolVersions, 0, this.protocols, 0, protocolVersions.length);
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public void execPBSZ(long pbsz) throws SSLException, IOException {
        if (pbsz < 0L || 0xFFFFFFFFL < pbsz) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(FTPSCommand._commands[2], String.valueOf(pbsz))) {
            throw new SSLException(this.getReplyString());
        }
    }

    public void execPROT(String prot) throws SSLException, IOException {
        if (prot == null) {
            prot = DEFAULT_PROT;
        }
        if (!this.checkPROTValue(prot)) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(FTPSCommand._commands[3], prot)) {
            throw new SSLException(this.getReplyString());
        }
        if (DEFAULT_PROT.equals(prot)) {
            this.setSocketFactory(null);
            this.setServerSocketFactory(null);
        } else {
            this.setSocketFactory(new FTPSSocketFactory(this.context));
            this.setServerSocketFactory(new FTPSServerSocketFactory(this.context));
            this.initSslContext();
        }
    }

    private boolean checkPROTValue(String prot) {
        for (int p = 0; p < PROT_COMMAND_VALUE.length; ++p) {
            if (!PROT_COMMAND_VALUE[p].equals(prot)) continue;
            return true;
        }
        return false;
    }

    public int sendCommand(String command, String args) throws IOException {
        int repCode = super.sendCommand(command, args);
        if (FTPSCommand._commands[4].equals(command)) {
            if (200 == repCode) {
                this._socket_ = this.plainSocket;
                this._controlInput_ = new BufferedReader(new InputStreamReader(this._socket_.getInputStream(), this.getControlEncoding()));
                this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._socket_.getOutputStream(), this.getControlEncoding()));
                this.setSocketFactory(null);
            } else {
                throw new SSLException(this.getReplyString());
            }
        }
        return repCode;
    }

    protected Socket _openDataConnection_(int command, String arg) throws IOException {
        Socket socket = super._openDataConnection_(command, arg);
        if (socket != null && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setUseClientMode(this.isClientMode);
            sslSocket.setEnableSessionCreation(this.isCreation);
            if (!this.isClientMode) {
                sslSocket.setNeedClientAuth(this.isNeedClientAuth);
                sslSocket.setWantClientAuth(this.isWantClientAuth);
            }
            if (this.suites != null) {
                sslSocket.setEnabledCipherSuites(this.suites);
            }
            if (this.protocols != null) {
                sslSocket.setEnabledProtocols(this.protocols);
            }
            sslSocket.startHandshake();
        }
        return socket;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }
}

