/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.BasicBean;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectInstance;

public class ObjStoreTypeBean
extends BasicBean {
    private static final Map<String, String[]> typeHandlers = new HashMap<String, String[]>(){
        {
            this.put("StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction", new String[]{"com.arjuna.ats.arjuna.tools.osb.mbean.common.AtomicActionBean", "com.arjuna.ats.arjuna.tools.osb.mbean.BasicActionBean"});
            this.put("Recovery/TransactionStatusManager", new String[]{"com.arjuna.ats.arjuna.tools.osb.mbean.common.TransactionStatusManagerItemBean"});
            this.put("StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple", new String[]{"com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ArjunaTransactionImpleBean", "com.arjuna.ats.arjuna.tools.osb.mbean.BasicActionBean"});
            this.put("RecoveryCoordinator", new String[]{"com.arjuna.ats.internal.jta.tools.osb.mbean.jts.RecoveryCoordinatorBean", "com.arjuna.ats.arjuna.tools.osb.mbean.common.UidBean"});
            this.put("CosTransactions/XAResourceRecord", new String[]{"com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSXAResourceRecordBean", "com.arjuna.ats.arjuna.tools.osb.mbean.common.UidBean"});
        }
    };
    private String type;
    private String storeName;
    protected List<BasicBean> registeredBeans = new ArrayList<BasicBean>();

    public ObjStoreTypeBean() {
    }

    public ObjStoreTypeBean(ObjStoreTypeBean parent, String storeName, String type) {
        super(parent, type);
        this.parent = parent;
        this.type = type;
        this.storeName = storeName;
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_1", new Object[]{type, storeName});
        }
    }

    public ObjectStore getStore() {
        return ((ObjStoreTypeBean)this.parent).getStore();
    }

    @Override
    public String getObjectName() {
        return this.toObjectName(this.storeName, this.type).toString();
    }

    protected StringBuilder toObjectName(String storeName, String type) {
        StringBuilder on = new StringBuilder();
        String[] nc = type.split("/");
        on.append(this.parent.getObjectName()).append(',');
        on.append("name=").append(storeName);
        for (int i = 0; i < nc.length; ++i) {
            on.append(',').append('L').append(i + 1).append("=").append(nc[i]);
        }
        return on;
    }

    private void allUids(Collection<Uid> uis) {
        block7: {
            InputObjectState uids = new InputObjectState();
            try {
                if (!this.getStore().allObjUids(this.type, uids)) break block7;
                try {
                    boolean endOfUids = false;
                    while (!endOfUids) {
                        Uid theUid = UidHelper.unpackFrom(uids);
                        if (theUid.equals(Uid.nullUid())) {
                            endOfUids = true;
                            continue;
                        }
                        uis.add(new Uid(theUid));
                    }
                }
                catch (IOException e) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_2", new Object[]{this.type, e});
                    }
                }
            }
            catch (ObjectStoreException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block7;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_3", new Object[]{this.type, e});
            }
        }
    }

    @Override
    public void refresh() {
        this.clearErrors();
        this.unregisterDependents(true);
        this.register();
        Iterator<BasicBean> i = this.registeredBeans.iterator();
        while (i.hasNext()) {
            BasicBean bb = i.next();
            if (bb.isMarked()) continue;
            i.remove();
            bb.unregister();
        }
    }

    @Override
    public ObjectInstance register() {
        ArrayList<Uid> uids = new ArrayList<Uid>();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_4", new Object[]{this.getObjectName()});
        }
        this.allUids(uids);
        ObjectInstance oi = super.register();
        if (!uids.isEmpty()) {
            for (Uid uid : uids) {
                BasicBean bean = this.createBean(uid);
                if (bean == null) continue;
                this.registeredBeans.add(bean);
            }
        }
        return oi;
    }

    @Override
    public boolean unregister() {
        return super.unregister();
    }

    @Override
    public void unregisterDependents(boolean markOnly) {
        for (BasicBean osBean : this.registeredBeans) {
            if (markOnly) {
                osBean.mark();
                continue;
            }
            osBean.unregister();
        }
        if (!markOnly) {
            this.registeredBeans.clear();
        }
    }

    private BasicBean createBean(Uid uid) {
        String[] cnames = typeHandlers.get(this.type);
        if (cnames == null) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_5", new Object[]{this.type});
            }
            cnames = new String[]{"com.arjuna.ats.tools.osb.mbean.ObjStoreEntryBean"};
        }
        for (String cname : cnames) {
            try {
                Class<?> cl = Class.forName(cname);
                Constructor<?> ccon = cl.getConstructor(ObjStoreTypeBean.class, Uid.class);
                BasicBean action = (BasicBean)ccon.newInstance(this, uid);
                for (BasicBean registeredBean : this.registeredBeans) {
                    if (registeredBean != action) continue;
                    registeredBean.mark();
                    return null;
                }
                action.register();
                return action;
            }
            catch (Exception e) {
                if (!tsLogger.arjLoggerI18N.isDebugEnabled()) continue;
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_7", new Object[]{e.getMessage(), this.type});
            }
        }
        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean.m_6", new Object[]{this.type, "No suitable handler"});
        }
        return null;
    }
}

