/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.managers.BindingManager;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.MailingManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.TemplateManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.tasks.TasksManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImportExportService;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected WikittyProxy wikittyProxy;
    protected WikittyImportExportService importExportService;
    protected ThesaurusManager thesaurusManager;
    protected BindingManager bindingManager;
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected ClientManager clientManager;
    protected SearchManager searchManager;
    protected MailingManager mailingManager;
    protected TasksManager tasksManager;

    public VradiStorageServiceImpl() {
        this(ServiceFactory.getWikittyProxy());
    }

    protected VradiStorageServiceImpl(WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
        this.thesaurusManager = new ThesaurusManager(wikittyProxy);
        this.clientManager = new ClientManager(wikittyProxy);
        this.formTypeManager = new FormTypeManager(wikittyProxy);
        this.mailingManager = new MailingManager(wikittyProxy);
        this.searchManager = new SearchManager(wikittyProxy, this.thesaurusManager);
        this.formManager = new FormManager(wikittyProxy, this.thesaurusManager, this.searchManager);
        this.bindingManager = new BindingManager(wikittyProxy, this.formTypeManager, this.formManager);
        this.tasksManager = new TasksManager(wikittyProxy, this.mailingManager, this.bindingManager);
        this.tasksManager.initTasks();
        wikittyProxy.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this.tasksManager, WikittyService.ServiceListenerType.ALL);
    }

    protected WikittyImportExportService getImportExportService() {
        if (this.importExportService == null) {
            this.importExportService = new WikittyImportExportService(this.wikittyProxy.getSecurityToken(), this.wikittyProxy.getWikittyService());
        }
        return this.importExportService;
    }

    @Override
    public List<Status> createDefaultStatuses() throws VradiException {
        return this.formManager.createDefaultStatuses();
    }

    @Override
    public Session createNewSession() throws VradiException {
        return this.formManager.createNewSession();
    }

    @Override
    public Session bindForms(Session session) throws VradiException {
        return this.formManager.bindForms(session);
    }

    @Override
    public List<Sending> createAllSending(String sessionId, Group group, List<String> formsIdsToBind) throws VradiException {
        return this.formManager.createAllSending(sessionId, group, formsIdsToBind);
    }

    @Override
    public Sending createSending(String sessionId, User user, List<String> formsIdsToBind) throws VradiException {
        return this.formManager.createUserSending(sessionId, user, formsIdsToBind);
    }

    @Override
    public List<Sending> removeAllSending(String sessionId, List<String> formsIds, Group group) throws VradiException {
        return this.formManager.removeAllSending(sessionId, formsIds, group);
    }

    @Override
    public Sending removeSending(String sessionId, List<String> formsIds, User user) throws VradiException {
        return this.formManager.removeSending(sessionId, formsIds, user);
    }

    @Override
    public XmlStreamImportResult importFormsFromWebHarvestStream(WebHarvestStream webHarvestStream) throws VradiException {
        return this.bindingManager.importFormsFromWebHarvestStream(webHarvestStream);
    }

    @Override
    public XmlStreamImportResult importFormsFromXmlStream(XmlStream xmlStream) throws VradiException {
        return this.bindingManager.importFormsFromXmlStream(xmlStream);
    }

    @Override
    public VradiUser createUser(VradiUser user) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateVradiUser(" + user.getLogin() + ")"));
        }
        Search search = Search.query().eq("login", user.getLogin());
        Criteria criteria = search.criteria();
        criteria.setEndIndex(1);
        PagedResult users = this.wikittyProxy.findAllByCriteria(VradiUser.class, criteria);
        if (users.getNumFound() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + user.getLogin() + " already exists"));
            }
            return null;
        }
        return (VradiUser)this.wikittyProxy.store((BusinessEntity)user);
    }

    @Override
    public VradiUser loginUser(String login, String mp5password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("logVradiUser(" + login + ", " + mp5password + ")"));
        }
        Criteria criteria = Search.query().eq("WikittyUser.login", login).eq("WikittyUser.password", mp5password).criteria();
        criteria.setEndIndex(1);
        VradiUser vradiUser = (VradiUser)this.wikittyProxy.findByCriteria(VradiUser.class, criteria);
        return vradiUser;
    }

    @Override
    public void importAsCSV(String uri) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing data as CSV with url = " + uri));
        }
        try {
            WikittyImportExportService ieService = this.getImportExportService();
            ieService.syncImportFromUri(WikittyImportExportService.FORMAT.CSV, uri);
        }
        catch (WikittyException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import data", (Throwable)eee);
            }
            throw new VradiException("Can't import data", eee);
        }
    }

    @Override
    public String exportAsCSV(Criteria criteria) throws VradiException {
        String result;
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exporting data as CSV with criteria " + criteria));
            }
            result = null;
            try {
                WikittyImportExportService ieService = this.getImportExportService();
                result = ieService.syncExportAllByCriteria(WikittyImportExportService.FORMAT.CSV, criteria);
            }
            catch (WikittyException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't export data", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void reindexData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"reindexData()");
        }
        UpdateResponse response = this.wikittyProxy.getWikittyService().syncEngin(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)response.toString());
        }
    }

    @Override
    public void archiveQueries(QueryMaker queryMaker) throws VradiException {
        this.clientManager.archiveQueries(queryMaker);
    }

    @Override
    public void setAssociatedFields(String extensionName, String templateName, Map<String, String> fieldMap) throws VradiException {
        this.formTypeManager.setAssociatedFields(extensionName, templateName, fieldMap);
    }

    @Override
    public String generatePDF(String formId, boolean force) throws VradiException {
        String uri = null;
        String extensionName = null;
        Form form = (Form)this.wikittyProxy.restore(Form.class, formId);
        for (String ext : form.getExtensionNames()) {
            if (ext.equals("Infogene") || ext.equals("Form")) continue;
            extensionName = ext;
            break;
        }
        WikittyExtension extension = this.formTypeManager.getFormType(extensionName);
        String template = extension.getTagValue("template");
        File templateFile = this.formTypeManager.getTemplate(extensionName, template);
        Map<String, String> fieldMap = this.getAssociatedFields(extension.getName(), template);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating PDF file for form " + form.getWikittyId() + " (template = " + template + ")"));
        }
        try {
            List<Form> currentForms = Collections.singletonList(form);
            List<File> filesToAdd = this.generateFilledDocumentInPDF(templateFile, currentForms, fieldMap, force);
            if (filesToAdd != null && !filesToAdd.isEmpty()) {
                uri = filesToAdd.get(0).getName();
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate pdf", (Throwable)ex);
            }
            throw new VradiException("Can't generate pdf", ex);
        }
        return uri;
    }

    @Override
    public Map<String, String> getAssociatedFields(String extensionName, String templateName) throws VradiException {
        return this.formTypeManager.getAssociatedFields(extensionName, templateName);
    }

    @Override
    public List<String> getDocumentFields(WikittyExtension extension, String templateName) throws VradiException {
        List<String> documentsFields = null;
        try {
            File templateDir = VradiServiceConfiguration.getInstance(new String[0]).getTemplatesDir();
            File extensionTemplate = new File(templateDir, extension.getName());
            File templateFile = new File(extensionTemplate, templateName);
            TemplateManager templateManager = new TemplateManager(templateFile);
            documentsFields = templateManager.getDocumentFields();
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get documents fields", (Throwable)ex);
            }
            throw ex;
        }
        return documentsFields;
    }

    protected List<File> generateFilledDocumentInPDF(File template, List<Form> forms, Map<String, String> fieldBindings, boolean replace) throws VradiException {
        ArrayList<File> generatedPDFList = null;
        if (template == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Try to generate form pdf without template");
            }
        } else {
            TemplateManager templateManager = new TemplateManager(template);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (Map.Entry<String, String> binding : fieldBindings.entrySet()) {
                String fieldFQName = binding.getValue();
                if (fieldFQName == null || fieldFQName.indexOf(".") <= 0) continue;
                int dot = fieldFQName.indexOf(".");
                String[] fqField = new String[]{fieldFQName.substring(0, dot), fieldFQName.substring(dot + 1)};
                map.put(binding.getKey(), fqField);
            }
            generatedPDFList = new ArrayList<File>();
            for (Form form : forms) {
                File f = this.generateFilledDocumentInPDF(templateManager, form, map, replace);
                generatedPDFList.add(f);
            }
        }
        return generatedPDFList;
    }

    protected File generateFilledDocumentInPDF(TemplateManager templateManager, Form form, Map<String, String[]> fieldBindings, boolean replace) throws VradiException {
        File result = this.mailingManager.getGeneratedPdfFile(form);
        if (!replace && result.exists()) {
            return result;
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> binding : fieldBindings.entrySet()) {
            String[] fqField = binding.getValue();
            Object value = form.getField(fqField[0], fqField[1]);
            fieldValues.put(binding.getKey(), value != null ? value.toString() : null);
        }
        ArrayList<File> attachments = new ArrayList<File>();
        if (form.getFiles() != null) {
            File embeddedFilesDir = VradiServiceConfiguration.getInstance(new String[0]).getEmbeddedFilesDir();
            File formFilesDir = new File(embeddedFilesDir, form.getWikittyId());
            for (String file : form.getFiles()) {
                File f = new File(formFilesDir, file);
                attachments.add(f);
            }
        }
        templateManager.generateDoc(result.getPath(), fieldValues, attachments.toArray(new File[attachments.size()]));
        return result;
    }

    @Override
    public String sendMessages(String sessionId) throws VradiException {
        Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        if (VradiConstants.SessionStatus.isSent(session)) {
            return "";
        }
        if (VradiConstants.SessionStatus.isToRestart(session)) {
            log.info((Object)"Session was stopped or in error, resume sending");
            session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
            session.setSessionLogs("");
            session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        }
        ArrayList<String> sessionLogger = new ArrayList<String>();
        Set<String> sendingIds = session.getSending();
        if (sendingIds != null) {
            for (String sendingId : sendingIds) {
                String log;
                Sending sending;
                if (VradiConstants.SessionStatus.isStopped(session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId()))) {
                    VradiStorageServiceImpl.log.warn((Object)"Sending stopped by user");
                    sessionLogger.add(I18n._("vradi.error.session.stopped", session.getNum(), DateUtil.formatDate((Date)session.getSessionDate(), (String)"dd/MM/yyyy")));
                }
                if (VradiConstants.SendingStatus.isSent(sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId))) {
                    if (!VradiStorageServiceImpl.log.isDebugEnabled()) continue;
                    VradiStorageServiceImpl.log.debug((Object)("Sending " + sendingId + " already sent, skip"));
                    continue;
                }
                if (!VradiConstants.SendingStatus.isToSend(sending) || (log = this.sendMessage(sendingId, session.getParagraph())) == null) continue;
                sessionLogger.add(log);
            }
        }
        String formatedLogs = this.formatSessionLog(sessionLogger);
        if (sessionLogger.isEmpty()) {
            session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
            session.setSessionLogs("");
        } else {
            session.setStatus(VradiConstants.SessionStatus.ERROR.getValue());
            session.setSessionLogs(formatedLogs);
        }
        session.setSessionDate(new Date());
        this.wikittyProxy.store((BusinessEntity)session);
        return formatedLogs;
    }

    @Override
    public String sendMessage(String sendingId, String sessionParagraph) throws VradiException {
        return this.sendMessage(sendingId, sessionParagraph, null, false);
    }

    @Override
    public String sendMessage(String sendingId, String sessionParagraph, String email) throws VradiException {
        return this.sendMessage(sendingId, sessionParagraph, email, true);
    }

    public String sendMessage(String sendingId, String sessionParagraph, String email, boolean reSend) throws VradiException {
        String messageId;
        Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
        User user = this.clientManager.getUser(sending.getUser());
        if (!reSend && !VradiConstants.SendingStatus.isToSend(sending)) {
            return null;
        }
        if (StringUtils.isBlank((String)email) && StringUtils.isBlank((String)(email = user.getEmail()))) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("User " + user.getName() + " has not valid email (skip current mail sending)"));
            }
            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
            this.wikittyProxy.store((BusinessEntity)sending);
            return I18n._("vradi.error.sending.emailIsBlank", user.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending message to " + email));
        }
        String subject = VradiServiceConfiguration.getInstance(new String[0]).getOfferMailSubject();
        String message = sessionParagraph + "\n\n" + sending.getParagraph();
        Set<String> formsIds = SendingHelper.extractForms(this.wikittyProxy, sending.getGroupForms());
        if (formsIds == null) {
            return I18n._("vradi.error.sending.formsEmpty", user.getName());
        }
        List forms = this.wikittyProxy.restore(Form.class, new ArrayList<String>(formsIds));
        boolean receptionProof = sending.getReceptionProof();
        try {
            messageId = this.mailingManager.postMail(email, subject, message, forms, receptionProof);
        }
        catch (VradiException eee) {
            log.error((Object)("Failed to send sending for email : " + email), (Throwable)eee);
            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
            this.wikittyProxy.store((BusinessEntity)sending);
            return I18n._("vradi.error.sending.failedToSend", user.getName(), eee.getMessage());
        }
        sending.setMessageId(messageId);
        sending.setStatus(receptionProof ? VradiConstants.SendingStatus.WAITING_RECEPTION_PROOF.getValue() : VradiConstants.SendingStatus.SENT.getValue());
        this.wikittyProxy.store((BusinessEntity)sending);
        return null;
    }

    protected String formatSessionLog(List<String> logs) {
        return StringUtils.join(logs, (String)",\n");
    }

    @Override
    public void receiveMessages() throws VradiException {
        this.mailingManager.receiveMails();
    }

    @Override
    public Session stopSentMail(Session session) throws VradiException {
        session.setStatus(VradiConstants.SessionStatus.STOPPED.getValue());
        session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        return session;
    }

    @Override
    public void generatePDFForSession(String sessionId) throws VradiException {
        ArrayList<String> formsIdsToGenerate = new ArrayList<String>();
        Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        Set<String> sendingIds = session.getSending();
        if (sendingIds == null) {
            return;
        }
        for (String id : sendingIds) {
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, id);
            Set<String> formsIds = SendingHelper.extractForms(this.wikittyProxy, sending.getGroupForms());
            if (formsIds == null) continue;
            for (String formId : formsIds) {
                if (formsIdsToGenerate.contains(formId)) continue;
                formsIdsToGenerate.add(formId);
            }
        }
        for (String formId : formsIdsToGenerate) {
            try {
                this.generatePDF(formId, true);
            }
            catch (VradiException eee) {
                throw new VradiException("An error occurred while generating PDF file for form : " + formId, eee);
            }
        }
    }

    public List<Group> getGroupsForUser(String userId) throws VradiException {
        return this.clientManager.getGroupsForUser(userId);
    }

    @Override
    public String exportClientDB() throws VradiException {
        Search restriction = Search.query().or();
        restriction.eq(Element.ELT_EXTENSION, "Group");
        restriction.eq(Element.ELT_EXTENSION, "Client");
        restriction.eq(Element.ELT_EXTENSION, "User");
        Criteria criteria = restriction.criteria();
        String vscContent = this.exportAsCSV(criteria);
        return vscContent;
    }

    @Override
    public void deleteSession(String sessionId) throws VradiException {
        this.formManager.deleteSession(sessionId);
    }

    @Override
    public boolean checkTemplateExist(String extensionName) throws VradiException {
        boolean fileExists;
        try {
            WikittyExtension extension = this.formTypeManager.getFormType(extensionName);
            String templateName = this.formTypeManager.getFormTypeTemplateName(extension);
            if (templateName == null) {
                return false;
            }
            File template = this.formTypeManager.getTemplate(extensionName, templateName);
            fileExists = template != null && template.exists();
        }
        catch (Exception eee) {
            throw new VradiException("Can't check if template existe : ", eee);
        }
        return fileExists;
    }

    @Override
    public boolean removeFormsFromSession(String sessionId, List<String> formsIds) throws VradiException {
        return this.formManager.removeFormsFromSession(sessionId, formsIds);
    }

    @Override
    public Sending revertDeletion(String sendingId, List<String> formsIdsToUpdate) {
        return this.formManager.revertDeletion(sendingId, formsIdsToUpdate);
    }

    @Override
    public Sending revertUserDeletion(String sessionId, String userId, String formId) {
        return this.formManager.revertUserDeletion(sessionId, userId, formId);
    }

    @Override
    public List<Sending> revertGroupDeletion(String sessionId, String groupId, String formId) {
        return this.formManager.revertGroupDeletion(sessionId, groupId, formId);
    }
}

