/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.TCPGOSSIP;
import org.jgroups.stack.GossipRouter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "gossip-router"}, sequential=true)
public class TCPGOSSIP_Test
extends ChannelTestBase {
    private JChannel channel;
    private JChannel coordinator;
    private static final String GROUP = "TCPGOSSIP_Test";
    private GossipRouter gossipRouter;
    private static final String props = "tcpgossip.xml";

    @BeforeClass
    void startRouter() throws Exception {
        String bind_addr = this.getRouterBindAddress();
        this.gossipRouter = new GossipRouter(12001, bind_addr);
        this.gossipRouter.start();
    }

    private String getRouterBindAddress() {
        String bind_addr = Util.getProperty("jgroups.bind_addr");
        if (bind_addr == null) {
            StackType type = Util.getIpStackType();
            bind_addr = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        }
        return bind_addr;
    }

    @AfterClass(alwaysRun=true)
    void stopRouter() throws Exception {
        this.gossipRouter.stop();
    }

    @AfterMethod(alwaysRun=true)
    void tearDown() throws Exception {
        Util.close(this.channel, this.coordinator);
    }

    public void testDisconnectConnectTwo() throws Exception {
        this.coordinator = new JChannel(props);
        this.channel = new JChannel(props);
        this.coordinator.connect(GROUP);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect(GROUP);
        View view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
    }

    public void testAddInitialHosts() throws Exception {
        this.coordinator = new JChannel(props);
        this.channel = new JChannel(props);
        this.coordinator.connect(GROUP);
        this.channel.connect(GROUP);
        TCPGOSSIP p = (TCPGOSSIP)this.channel.getProtocolStack().findProtocol((Class<?>)TCPGOSSIP.class);
        String bind_addr = this.getRouterBindAddress();
        assert (p.removeInitialHost(bind_addr, 12001));
        p.addInitialHost(bind_addr, 12001);
        View view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectThree() throws Exception {
        JChannel third = null;
        try {
            this.coordinator = new JChannel(props);
            this.channel = new JChannel(props);
            this.coordinator.connect(GROUP);
            this.channel.connect(GROUP);
            third = new JChannel(props);
            third.connect(GROUP);
            View view = this.channel.getView();
            assert (this.channel.getView().size() == 3);
            assert (third.getView().size() == 3);
            assert (view.containsMember(this.channel.getAddress()));
            assert (view.containsMember(this.coordinator.getAddress()));
        }
        catch (Throwable throwable) {
            Util.close(third);
            throw throwable;
        }
        Util.close((Channel)third);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectThreeChannelsWithGRDown() throws Exception {
        JChannel third = null;
        try {
            this.coordinator = new JChannel(props);
            this.channel = new JChannel(props);
            this.coordinator.connect("testConnectThreeChannelsWithGRDown");
            this.channel.connect("testConnectThreeChannelsWithGRDown");
            this.gossipRouter.stop();
            third = new JChannel(props);
            third.connect("testConnectThreeChannelsWithGRDown");
            this.gossipRouter.start();
            Util.blockUntilViewsReceived(60000L, 500L, this.coordinator, this.channel, third);
            View view = this.channel.getView();
            assert (this.channel.getView().size() == 3);
            assert (third.getView().size() == 3);
            assert (view.containsMember(this.channel.getLocalAddress()));
            assert (view.containsMember(this.coordinator.getLocalAddress()));
        }
        catch (Throwable throwable) {
            Util.close(third);
            throw throwable;
        }
        Util.close((Channel)third);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectThreeChannelsWithGRAlreadyDown() throws Exception {
        JChannel third = null;
        try {
            this.coordinator = new JChannel(props);
            this.channel = new JChannel(props);
            this.gossipRouter.stop();
            this.coordinator.connect("testConnectThreeChannelsWithGRAlreadyDown");
            this.channel.connect("testConnectThreeChannelsWithGRAlreadyDown");
            third = new JChannel(props);
            third.connect("testConnectThreeChannelsWithGRAlreadyDown");
            this.gossipRouter.start();
            Util.blockUntilViewsReceived(60000L, 500L, this.coordinator, this.channel, third);
            View view = this.channel.getView();
            assert (this.channel.getView().size() == 3);
            assert (third.getView().size() == 3);
            assert (view.containsMember(this.channel.getLocalAddress()));
            assert (view.containsMember(this.coordinator.getLocalAddress()));
        }
        catch (Throwable throwable) {
            Util.close(third);
            throw throwable;
        }
        Util.close((Channel)third);
    }
}

