/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TpHeader;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class StreamableTest {
    static final short PING_ID = 100;
    static final short UDP_ID = 101;

    public static void testStreamable() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, 0, 4);
        Message m2 = new Message(null, null, buf, 4, 3);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        m1.writeTo(out);
        out.close();
        byte[] tmp = output.toByteArray();
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(tmp);
        DataInputStream in = new DataInputStream(input);
        Message m3 = new Message(false);
        m3.readFrom(in);
        Assert.assertEquals((int)4, (int)m3.getLength());
        Assert.assertEquals((int)4, (int)m3.getRawBuffer().length);
        Assert.assertEquals((int)4, (int)m3.getBuffer().length);
        Assert.assertEquals((int)0, (int)m3.getOffset());
        output = new ByteArrayOutputStream();
        out = new DataOutputStream(output);
        m2.writeTo(out);
        out.close();
        tmp = output.toByteArray();
        output.close();
        System.out.println("-- serialized buffer is " + tmp.length + " bytes");
        input = new ByteArrayInputStream(tmp);
        in = new DataInputStream(input);
        Message m4 = new Message();
        m4.readFrom(in);
        Assert.assertEquals((int)3, (int)m4.getLength());
        Assert.assertEquals((int)3, (int)m4.getBuffer().length);
        Assert.assertEquals((int)3, (int)m4.getRawBuffer().length);
        Assert.assertEquals((int)0, (int)m4.getOffset());
    }

    public static void testStreamable2() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message msg = new Message(null, null, buf, 0, 4);
        StreamableTest.stream(msg);
    }

    public static void testStreamable3() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message msg = new Message(null, null, buf, 4, 3);
        StreamableTest.stream(msg);
    }

    public static void testNullBuffer() throws Exception {
        Message msg = new Message();
        StreamableTest.stream(msg);
    }

    public static void testNonNullBuffer() throws Exception {
        Message msg = new Message(null, null, "Hello world".getBytes());
        StreamableTest.stream(msg);
    }

    public static void testNonNullAddress() throws Exception {
        StreamableTest.stream(new Message(null, (Address)UUID.randomUUID(), "Hello world".getBytes()));
    }

    public static void testHeaders() throws Exception {
        UUID dest = UUID.randomUUID();
        UUID src = UUID.randomUUID();
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        PingHeader hdr = new PingHeader(1, new PingData(src, Util.createView(src, 1L, src), true));
        msg.putHeader((short)100, hdr);
        TpHeader udp_hdr = new TpHeader("bla");
        msg.putHeader((short)101, udp_hdr);
        StreamableTest.stream(msg);
    }

    public static void testAdditionalData() throws Exception {
        UUID dest = UUID.randomUUID();
        dest.setAdditionalData("foo".getBytes());
        UUID src = UUID.randomUUID();
        src.setAdditionalData("foobar".getBytes());
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        PingHeader hdr = new PingHeader(1, new PingData(src, Util.createView(src, 1L, src), false));
        msg.putHeader((short)100, hdr);
        TpHeader udp_hdr = new TpHeader("bla");
        msg.putHeader((short)101, udp_hdr);
        StreamableTest.stream(msg);
    }

    public static void testMergeView() throws Exception {
        UUID a = UUID.randomUUID();
        UUID b = UUID.randomUUID();
        UUID c = UUID.randomUUID();
        UUID d = UUID.randomUUID();
        UUID e = UUID.randomUUID();
        UUID f = UUID.randomUUID();
        Vector<Address> tmp_m1 = new Vector<Address>();
        Vector<Address> tmp_m2 = new Vector<Address>();
        Vector<Address> m3 = new Vector<Address>();
        Vector<Address> all = new Vector<Address>();
        Vector<View> subgroups = new Vector<View>();
        tmp_m1.add(a);
        tmp_m1.add(b);
        tmp_m1.add(c);
        tmp_m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, tmp_m1);
        MergeView v2 = new MergeView(d, 2L, tmp_m2, new Vector<View>());
        View v3 = new View(e, 3L, m3);
        MergeView v4 = new MergeView(e, 4L, m3, null);
        View v5 = new View(e, 5L, m3);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        subgroups.add(v4);
        subgroups.add(v5);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        Vector<View> sub = view_all.getSubgroups();
        assert (sub.get(0) instanceof View);
        assert (sub.get(1) instanceof MergeView);
        assert (sub.get(2) instanceof View);
        assert (sub.get(3) instanceof MergeView);
        assert (sub.get(4) instanceof View);
        byte[] buf = Util.streamableToByteBuffer(view_all);
        assert (buf != null);
        assert (buf.length > 0);
        MergeView merge_view = (MergeView)Util.streamableFromByteBuffer(MergeView.class, buf);
        assert (merge_view != null);
        System.out.println("MergeView: " + merge_view);
        sub = merge_view.getSubgroups();
        assert (sub.get(0) instanceof View);
        assert (sub.get(1) instanceof MergeView);
        assert (sub.get(2) instanceof View);
        assert (sub.get(3) instanceof MergeView);
        assert (sub.get(4) instanceof View);
    }

    private static void stream(Message msg) throws Exception {
        Address dest = msg.getDest();
        int num_headers = StreamableTest.getNumHeaders(msg);
        int length = msg.getLength();
        int bufLength = StreamableTest.getBufLength(msg);
        Address src = msg.getSrc();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        msg.writeTo(out);
        out.close();
        byte[] tmp = output.toByteArray();
        output.close();
        System.out.println("-- serialized buffer is " + tmp.length + " bytes");
        ByteArrayInputStream input = new ByteArrayInputStream(tmp);
        DataInputStream in = new DataInputStream(input);
        Message msg2 = new Message();
        msg2.readFrom(in);
        Assert.assertEquals((int)length, (int)msg2.getLength());
        Assert.assertEquals((int)bufLength, (int)StreamableTest.getBufLength(msg2));
        assert (StreamableTest.match(dest, msg2.getDest()));
        assert (StreamableTest.match(src, msg2.getSrc()));
        Assert.assertEquals((int)num_headers, (int)StreamableTest.getNumHeaders(msg2));
    }

    private static int getNumHeaders(Message msg) {
        return msg.getNumHeaders();
    }

    private static boolean match(Address a1, Address a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null) {
            return a1.equals(a2);
        }
        return a2.equals(a1);
    }

    private static int getBufLength(Message msg) {
        return msg.getBuffer() != null ? msg.getBuffer().length : 0;
    }
}

