/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.Util;

public class MessageListStreamableTest {
    static final Log log = LogFactory.getLog(MessageListStreamableTest.class);
    static final short UDP_ID = 100;
    static final short PING_ID = 101;
    static final short FD_SOCK_ID = 102;
    static final short VERIFY_SUSPECT_ID = 103;
    static final short STABLE_ID = 104;
    static final short NAKACK_ID = 105;
    static final short UNICAST_ID = 106;
    static final short FRAG_ID = 107;
    static final short GMS_ID = 108;

    public static void main(String[] args) throws Exception {
        boolean add_headers = false;
        InetAddress addr = InetAddress.getLocalHost();
        int num = 10000;
        for (int i = 0; i < args.length; ++i) {
            if ("-add_headers".equals(args[i])) {
                add_headers = true;
                continue;
            }
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            MessageListStreamableTest.help();
            return;
        }
        LinkedList<Message> list = new LinkedList<Message>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            Message m = new Message((Address)new IpAddress(addr, 5555), (Address)new IpAddress(addr, 6666), new byte[256]);
            if (add_headers) {
                MessageListStreamableTest.addHeaders(m);
            }
            list.add(m);
        }
        start = System.currentTimeMillis();
        Buffer buf = Util.msgListToByteBuffer(list);
        long stop = System.currentTimeMillis();
        System.out.println("Marshalling a message list of " + list.size() + " elements took " + (stop - start) + "ms.");
        start = System.currentTimeMillis();
        List<Message> list2 = Util.byteBufferToMessageList(buf.getBuf(), buf.getOffset(), buf.getLength());
        stop = System.currentTimeMillis();
        System.out.println("Unmarshalling a message list of " + list2.size() + " elements took " + (stop - start) + "ms.");
    }

    static void addHeaders(Message msg) {
        msg.putHeader((short)100, new TpHeader("MyGroup"));
        msg.putHeader((short)101, new PingHeader(1, "demo-cluster"));
        msg.putHeader((short)102, new FD_SOCK.FdHeader());
        msg.putHeader((short)103, new VERIFY_SUSPECT.VerifyHeader());
        msg.putHeader((short)104, new STABLE.StableHeader());
        msg.putHeader((short)105, new NakAckHeader());
        msg.putHeader((short)106, new UNICAST.UnicastHeader());
        msg.putHeader((short)107, new FragHeader());
        msg.putHeader((short)108, new GMS.GmsHeader());
    }

    static void help() {
        System.out.println("MessageSerializationTest [-help] [-add_headers] [-num <iterations>] [-use_magic] [-use_streamable]");
    }
}

