/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTable;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ConnectionTableUnitTest {
    ConnectionTable ct1;
    ConnectionTable ct2;
    static final int port1 = 5555;
    static final int port2 = 6666;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.ct1 = new ConnectionTable(5555);
        this.ct1.setUseSendQueues(false);
        this.ct1.start();
        this.ct2 = new ConnectionTable(6666);
        this.ct2.setUseSendQueues(false);
        this.ct2.start();
    }

    @AfterMethod
    void tearDown() throws Exception {
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
    }

    public void testSetup() {
        Assert.assertNotSame((Object)this.ct1.getLocalAddress(), (Object)this.ct2.getLocalAddress());
    }

    public void testSendToNullReceiver() throws Exception {
        byte[] data = new byte[]{};
        this.ct1.send(null, data, 0, data.length);
    }

    public void testSendEmptyData() throws Exception {
        byte[] data = new byte[]{};
        Address myself = this.ct1.getLocalAddress();
        this.ct1.setReceiver(new BasicConnectionTable.Receiver(){

            @Override
            public void receive(Address sender, byte[] data, int offset, int length) {
            }
        });
        this.ct1.send(myself, data, 0, data.length);
    }

    public void testSendNullData() throws Exception {
        Address myself = this.ct1.getLocalAddress();
        this.ct1.send(myself, null, 0, 0);
    }

    public void testSendToSelf() throws Exception {
        long NUM = 1000L;
        Address myself = this.ct1.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct1, NUM, false);
        byte[] data = new byte[]{98, 101, 108, 97};
        this.ct1.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(myself, data, 0, 0);
            ++i;
        }
        ConnectionTableUnitTest.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        ConnectionTableUnitTest.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        Assert.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOther() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct2, NUM, false);
        byte[] data = new byte[]{98, 101, 108, 97};
        this.ct2.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(other, data, 0, 0);
            ++i;
        }
        ConnectionTableUnitTest.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        ConnectionTableUnitTest.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        Assert.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOtherGetResponse() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r1 = new MyReceiver(this.ct1, NUM, false);
        MyReceiver r2 = new MyReceiver(this.ct2, NUM, true);
        byte[] data = new byte[]{98, 101, 108, 97};
        this.ct1.setReceiver(r1);
        this.ct2.setReceiver(r2);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(other, data, 0, 0);
            ++i;
        }
        ConnectionTableUnitTest.log("sent " + NUM + " msgs");
        r1.waitForCompletion();
        long total_time = r1.stop_time - r1.start_time;
        ConnectionTableUnitTest.log("number expected=" + r1.getNumExpected() + ", number received=" + r1.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r1.getNumReceived() + " ms/msg)");
        Assert.assertEquals((long)r1.getNumExpected(), (long)r1.getNumReceived());
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }

    static class MyReceiver
    implements BasicConnectionTable.Receiver {
        long num_expected = 0L;
        long num_received = 0L;
        long start_time = 0L;
        long stop_time = 0L;
        boolean done = false;
        boolean send_response = false;
        long modulo;
        ConnectionTable ct;

        MyReceiver(ConnectionTable ct, long num_expected, boolean send_response) {
            this.ct = ct;
            this.num_expected = num_expected;
            this.send_response = send_response;
            this.start_time = System.currentTimeMillis();
            this.modulo = num_expected / 10L;
        }

        public long getNumReceived() {
            return this.num_received;
        }

        public long getNumExpected() {
            return this.num_expected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Address sender, byte[] data, int offset, int length) {
            ++this.num_received;
            if (this.num_received % this.modulo == 0L) {
                ConnectionTableUnitTest.log("received msg# " + this.num_received);
            }
            if (this.send_response && this.ct != null) {
                try {
                    byte[] rsp = new byte[]{};
                    this.ct.send(sender, rsp, 0, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.num_received >= this.num_expected) {
                MyReceiver myReceiver = this;
                synchronized (myReceiver) {
                    if (!this.done) {
                        this.done = true;
                        this.stop_time = System.currentTimeMillis();
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

