/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Whitespace;

public class XSLPerformSort
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return this.getCommonChildItemType();
        }
        TypeHierarchy typeHierarchy = this.getNamePool().getTypeHierarchy();
        return this.select.getItemType(typeHierarchy);
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkSortComesFirst(true);
        if (this.select != null) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo instanceof XSLSort || nodeInfo instanceof XSLFallback) continue;
                if (nodeInfo.getNodeKind() == 3 && !Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                    this.compileError("Within xsl:perform-sort, significant text must not appear if there is a select attribute");
                    continue;
                }
                ((StyleElement)nodeInfo).compileError("Within xsl:perform-sort, child instructions are not allowed if there is a select attribute");
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) throws XPathException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        if (this.select != null) {
            SortExpression sortExpression = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(sortExpression);
            return sortExpression;
        }
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression == null) {
            expression = EmptySequence.getInstance();
        }
        try {
            SortExpression sortExpression = new SortExpression(expression.simplify(this.getStaticContext()), sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(sortExpression);
            return sortExpression;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

