/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuiton.util.Transformer;

public class TransformedList<E>
extends AbstractList<E>
implements Serializable {
    private static final long serialVersionUID = 2354881761407900789L;
    protected Transformer<E, ? super Object> transformer;
    protected List<Object> inner;

    public TransformedList(Transformer<E, ? super Object> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        this.transformer = transformer;
        this.inner = new ArrayList<Object>();
    }

    public TransformedList(Transformer<E, ? super Object> transformer, Collection<? extends E> c) {
        this(transformer);
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public E get(int index) {
        Object f = this.inner.get(index);
        E result = this.transformer.untransform(f);
        return result;
    }

    @Override
    public E set(int index, E element) {
        Object f = this.transformer.transform(element);
        f = this.inner.set(index, f);
        E result = this.transformer.untransform(f);
        return result;
    }

    @Override
    public void add(int index, E element) {
        Object f = this.transformer.transform(element);
        this.inner.add(index, f);
    }

    @Override
    public E remove(int index) {
        Object f = this.inner.remove(index);
        E result = this.transformer.untransform(f);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.transformer);
        out.writeObject(this.inner);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.transformer = (Transformer)in.readObject();
        this.inner = (List)in.readObject();
    }
}

