/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceNotifier;

public class XMPPNotifierTransporter
implements PacketListener,
WikittyServiceNotifier.RemoteNotifierTransporter {
    private static Log log = LogFactory.getLog(XMPPNotifierTransporter.class);
    public static final String PROPERTY_EVENT_NAME = "wikitty-event";
    public static final String WIKITTY_XMPP_SERVER = "wikitty.xmpp.server";
    public static final String WIKITTY_XMPP_ROOM = "wikitty.xmpp.room";
    public static final String WIKITTY_NOTIFICATION_PERSISTENT = "wikitty.notification.persistent";
    protected WikittyServiceNotifier ws;
    protected boolean persistent = false;
    protected String room;
    protected String pseudo;
    protected XMPPConnection connection;
    protected MultiUserChat muc;

    public XMPPNotifierTransporter(WikittyServiceNotifier ws, Properties props) {
        this.ws = ws;
        this.initXMPP(props);
    }

    protected void initXMPP(Properties props) {
        ApplicationConfig config = new ApplicationConfig(props);
        this.persistent = config.getOptionAsBoolean(WIKITTY_NOTIFICATION_PERSISTENT);
        String server = config.getOption(WIKITTY_XMPP_SERVER);
        this.room = config.getOption(WIKITTY_XMPP_ROOM);
        this.pseudo = XMPPNotifierTransporter.getUniqueLoginName();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Try to connect to xmpp serveur " + server + " with pseudo " + this.pseudo + " in room " + this.room + " persistent " + this.persistent));
            }
            this.connection = new XMPPConnection(server);
            this.connection.connect();
            this.connection.loginAnonymously();
            DiscussionHistory history = new DiscussionHistory();
            if (this.persistent) {
                Date date = new Date();
                history.setSince(date);
            } else {
                history.setMaxChars(0);
            }
            this.muc = new MultiUserChat(this.connection, this.room);
            this.muc.join(this.pseudo, "", history, 4000L);
            this.muc.addMessageListener((PacketListener)this);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't connect to xmpp serveur", eee);
        }
    }

    @Override
    public void sendMessage(WikittyServiceEvent event) throws Exception {
        Message message = this.muc.createMessage();
        message.setBody(event.getType().toString());
        message.setProperty(PROPERTY_EVENT_NAME, (Object)event);
        this.muc.sendMessage(message);
    }

    public void processPacket(Packet packet) {
        String name = this.room + "/" + this.pseudo;
        if (!name.equals(packet.getFrom())) {
            Object event = packet.getProperty(PROPERTY_EVENT_NAME);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receive message : " + event));
            }
            if (event instanceof WikittyServiceEvent) {
                this.ws.processRemoteEvent((WikittyServiceEvent)event);
            }
        }
    }

    public static String getUniqueLoginName() {
        String result = UUID.randomUUID().toString();
        try {
            String ipv4 = null;
            String ipv6 = null;
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface netint = e.nextElement();
                Enumeration<InetAddress> a = netint.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress ip = a.nextElement();
                    if (ip instanceof Inet4Address) {
                        if (ipv4 != null && !"127.0.0.1".equals(ipv4)) continue;
                        ipv4 = ip.getHostAddress();
                        continue;
                    }
                    if (ip instanceof Inet6Address) {
                        if (ipv6 != null) continue;
                        ipv6 = ip.getHostAddress();
                        continue;
                    }
                    log.error((Object)("Can't get ip from no ipv4 and no ipv6: " + ip));
                }
            }
            if (ipv4 != null) {
                result = ipv4 + "=" + result;
            } else if (ipv6 != null) {
                result = ipv6 + "=" + result;
            }
        }
        catch (Exception eee) {
            log.error((Object)"Can't compute unique name from network interface", (Throwable)eee);
        }
        return result;
    }
}

