/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.util;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.BasicBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXServer {
    private static MBeanServer server;
    private static JMXServer agent;
    private List<BasicBean> registeredBeans = new ArrayList<BasicBean>();

    public static JMXServer getAgent() {
        return agent;
    }

    public JMXServer() {
        Class<?> c1;
        try {
            c1 = Class.forName("com.arjuna.ats.internal.jta.Implementations");
            c1.getMethod("initialise", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            c1 = Class.forName("com.arjuna.ats.internal.jts.Implementations");
            Class<?> c2 = Class.forName("com.arjuna.ats.internal.jta.Implementationsx");
            c1.getMethod("initialise", new Class[0]).invoke(null, new Object[0]);
            c2.getMethod("initialise", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MBeanServer getServer() {
        ArrayList<MBeanServer> servers;
        if (server == null && (server = (servers = MBeanServerFactory.findMBeanServer(null)) != null && servers.size() > 0 ? (MBeanServer)servers.get(0) : ManagementFactory.getPlatformMBeanServer()) == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }

    public ObjectInstance registerMBean(BasicBean bean) {
        ObjectInstance oi;
        block5: {
            oi = null;
            try {
                if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_1", new Object[]{bean.getObjectName()});
                }
                oi = this.getServer().registerMBean(bean, new ObjectName(bean.getObjectName()));
                this.registeredBeans.add(bean);
            }
            catch (InstanceAlreadyExistsException e) {
                if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_2", new Object[]{bean.getObjectName()});
                }
            }
            catch (JMException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_3", new Object[]{bean.getObjectName(), e.getMessage()});
            }
        }
        return oi;
    }

    public boolean unregisterMBean(String objectName) {
        boolean unregistered;
        block3: {
            unregistered = false;
            try {
                unregistered = this.unregisterMBean(new ObjectName(objectName));
                Iterator<BasicBean> i = this.registeredBeans.iterator();
                while (i.hasNext()) {
                    BasicBean bb = i.next();
                    if (!objectName.equals(bb.getObjectName())) continue;
                    i.remove();
                    break;
                }
            }
            catch (MalformedObjectNameException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_4", new Object[]{e.getMessage()});
            }
        }
        return unregistered;
    }

    public boolean unregisterMBean(ObjectName objectName) {
        block4: {
            try {
                this.getServer().unregisterMBean(objectName);
                return true;
            }
            catch (InstanceNotFoundException e) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_5", new Object[]{objectName, e.getMessage()});
                }
            }
            catch (MBeanRegistrationException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.util.JMXServer.m_6", new Object[]{objectName, e.getMessage()});
            }
        }
        return false;
    }

    static {
        agent = new JMXServer();
    }
}

