/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class AbstractConnector
extends HttpBuffers
implements Connector {
    private String _name;
    private Server _server;
    private ThreadPool _threadPool;
    private String _host;
    private int _port = 0;
    private String _integralScheme = "https";
    private int _integralPort = 0;
    private String _confidentialScheme = "https";
    private int _confidentialPort = 0;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private int _acceptorPriorityOffset = 0;
    private boolean _useDNS;
    private boolean _forwarded;
    private String _hostHeader;
    private String _forwardedHostHeader = "X-Forwarded-Host";
    private String _forwardedServerHeader = "X-Forwarded-Server";
    private String _forwardedForHeader = "X-Forwarded-For";
    private boolean _reuseAddress = true;
    protected int _maxIdleTime = 200000;
    protected int _lowResourceMaxIdleTime = -1;
    protected int _soLingerTime = -1;
    private transient Thread[] _acceptorThread;
    private final AtomicLong _statsStartedAt = new AtomicLong(-1L);
    private final CounterStatistic _connectionStats = new CounterStatistic();
    private final SampleStatistic _requestStats = new SampleStatistic();
    private final SampleStatistic _connectionDurationStats = new SampleStatistic();

    public final Buffer newBuffer(int size) {
        return null;
    }

    public Buffer newRequestBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    public Buffer newRequestHeader(int size) {
        return new ByteArrayBuffer(size);
    }

    public Buffer newResponseBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    public Buffer newResponseHeader(int size) {
        return new ByteArrayBuffer(size);
    }

    protected boolean isRequestHeader(Buffer buffer) {
        return true;
    }

    protected boolean isResponseHeader(Buffer buffer) {
        return true;
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this._threadPool = pool;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getLowResourcesMaxIdleTime() {
        return this._lowResourceMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(int maxIdleTime) {
        this._lowResourceMaxIdleTime = maxIdleTime;
    }

    public final int getLowResourceMaxIdleTime() {
        return this.getLowResourcesMaxIdleTime();
    }

    public final void setLowResourceMaxIdleTime(int maxIdleTime) {
        this.setLowResourcesMaxIdleTime(maxIdleTime);
    }

    public int getSoLingerTime() {
        return this._soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public void setAcceptors(int acceptors) {
        this._acceptors = acceptors;
    }

    public void setSoLingerTime(int soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this._server == null) {
            throw new IllegalStateException("No server");
        }
        this.open();
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this._server.getThreadPool();
        }
        if (this._threadPool != this._server.getThreadPool() && this._threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this._threadPool)).start();
        }
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            this._acceptorThread = new Thread[this.getAcceptors()];
            for (int i = 0; i < this._acceptorThread.length; ++i) {
                if (this._threadPool.dispatch(new Acceptor(i))) continue;
                Log.warn("insufficient maxThreads configured for {}", this);
                break;
            }
        }
        Log.info("Started {}", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            this.close();
        }
        catch (IOException e) {
            Log.warn(e);
        }
        if (this._threadPool != this._server.getThreadPool() && this._threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this._threadPool)).stop();
        }
        super.doStop();
        Thread[] acceptors = null;
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            acceptors = this._acceptorThread;
            this._acceptorThread = null;
        }
        if (acceptors != null) {
            for (int i = 0; i < acceptors.length; ++i) {
                Thread thread = acceptors[i];
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    public void join() throws InterruptedException {
        Thread[] threads = this._acceptorThread;
        if (threads != null) {
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].join();
            }
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._soLingerTime >= 0) {
                socket.setSoLinger(true, this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        if (this.isForwarded()) {
            this.checkForwardedHeaders(endpoint, request);
        }
    }

    protected void checkForwardedHeaders(EndPoint endpoint, Request request) throws IOException {
        HttpFields httpFields = request.getConnection().getRequestFields();
        String forwardedHost = this.getLeftMostValue(httpFields.getStringField(this.getForwardedHostHeader()));
        String forwardedServer = this.getLeftMostValue(httpFields.getStringField(this.getForwardedServerHeader()));
        String forwardedFor = this.getLeftMostValue(httpFields.getStringField(this.getForwardedForHeader()));
        if (this._hostHeader != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, this._hostHeader);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedHost != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, forwardedHost);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedServer != null) {
            request.setServerName(forwardedServer);
        }
        if (forwardedFor != null) {
            request.setRemoteAddr(forwardedFor);
            InetAddress inetAddress = null;
            if (this._useDNS) {
                try {
                    inetAddress = InetAddress.getByName(forwardedFor);
                }
                catch (UnknownHostException e) {
                    Log.ignore(e);
                }
            }
            request.setRemoteHost(inetAddress == null ? forwardedFor : inetAddress.getHostName());
        }
    }

    protected String getLeftMostValue(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        int commaIndex = headerValue.indexOf(44);
        if (commaIndex == -1) {
            return headerValue;
        }
        return headerValue.substring(0, commaIndex);
    }

    public void persist(EndPoint endpoint) throws IOException {
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public boolean isIntegral(Request request) {
        return false;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public boolean isConfidential(Request request) {
        return false;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    public void stopAccept(int acceptorID) throws Exception {
    }

    public boolean getResolveNames() {
        return this._useDNS;
    }

    public void setResolveNames(boolean resolve) {
        this._useDNS = resolve;
    }

    public boolean isForwarded() {
        return this._forwarded;
    }

    public void setForwarded(boolean check) {
        if (check) {
            Log.debug(this + " is forwarded");
        }
        this._forwarded = check;
    }

    public String getHostHeader() {
        return this._hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this._hostHeader = hostHeader;
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String forwardedHostHeader) {
        this._forwardedHostHeader = forwardedHostHeader;
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String forwardedServerHeader) {
        this._forwardedServerHeader = forwardedServerHeader;
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String forwardedRemoteAddressHeader) {
        this._forwardedForHeader = forwardedRemoteAddressHeader;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + "@" + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    public String getName() {
        if (this._name == null) {
            this._name = (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getRequests() {
        return (int)this._requestStats.getTotal();
    }

    public long getConnectionsDurationTotal() {
        return this._connectionDurationStats.getTotal();
    }

    public int getConnections() {
        return (int)this._connectionStats.getTotal();
    }

    public int getConnectionsOpen() {
        return (int)this._connectionStats.getCurrent();
    }

    public int getConnectionsOpenMax() {
        return (int)this._connectionStats.getMax();
    }

    public double getConnectionsDurationMean() {
        return this._connectionDurationStats.getMean();
    }

    public long getConnectionsDurationMax() {
        return this._connectionDurationStats.getMax();
    }

    public double getConnectionsDurationStdDev() {
        return this._connectionDurationStats.getStdDev();
    }

    public double getConnectionsRequestsMean() {
        return this._requestStats.getMean();
    }

    public int getConnectionsRequestsMax() {
        return (int)this._requestStats.getMax();
    }

    public double getConnectionsRequestsStdDev() {
        return this._requestStats.getStdDev();
    }

    public void statsReset() {
        this.updateNotEqual(this._statsStartedAt, -1L, System.currentTimeMillis());
        this._requestStats.reset();
        this._connectionStats.reset();
        this._connectionDurationStats.reset();
    }

    public void setStatsOn(boolean on) {
        if (on && this._statsStartedAt.get() != -1L) {
            return;
        }
        Log.debug("Statistics on = " + on + " for " + this);
        this.statsReset();
        this._statsStartedAt.set(on ? System.currentTimeMillis() : -1L);
    }

    public boolean getStatsOn() {
        return this._statsStartedAt.get() != -1L;
    }

    public long getStatsOnMs() {
        long start = this._statsStartedAt.get();
        return start != -1L ? System.currentTimeMillis() - start : 0L;
    }

    protected void connectionOpened(Connection connection) {
        if (this._statsStartedAt.get() == -1L) {
            return;
        }
        this._connectionStats.increment();
    }

    protected void connectionUpgraded(Connection oldConnection, Connection newConnection) {
        this._requestStats.set(oldConnection instanceof HttpConnection ? (long)((HttpConnection)oldConnection).getRequests() : 0L);
    }

    protected void connectionClosed(Connection connection) {
        if (this._statsStartedAt.get() == -1L) {
            return;
        }
        long duration = System.currentTimeMillis() - connection.getTimeStamp();
        int requests = connection instanceof HttpConnection ? ((HttpConnection)connection).getRequests() : 0;
        this._requestStats.set(requests);
        this._connectionStats.decrement();
        this._connectionDurationStats.set(duration);
    }

    public int getAcceptorPriorityOffset() {
        return this._acceptorPriorityOffset;
    }

    public void setAcceptorPriorityOffset(int offset) {
        this._acceptorPriorityOffset = offset;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this._reuseAddress = reuseAddress;
    }

    public boolean isLowResources() {
        if (this._threadPool != null) {
            return this._threadPool.isLowOnThreads();
        }
        return this._server.getThreadPool().isLowOnThreads();
    }

    private void updateNotEqual(AtomicLong valueHolder, long compare, long value) {
        long oldValue = valueHolder.get();
        while (compare != oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    private class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String name;
            Thread current = Thread.currentThread();
            AbstractConnector abstractConnector = AbstractConnector.this;
            synchronized (abstractConnector) {
                if (AbstractConnector.this._acceptorThread == null) {
                    return;
                }
                ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = current;
                name = AbstractConnector.this._acceptorThread[this._acceptor].getName();
                current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractConnector.this);
            }
            int old_priority = current.getPriority();
            try {
                current.setPriority(old_priority - AbstractConnector.this._acceptorPriorityOffset);
                while (AbstractConnector.this.isRunning() && AbstractConnector.this.getConnection() != null) {
                    try {
                        AbstractConnector.this.accept(this._acceptor);
                    }
                    catch (EofException e) {
                        Log.ignore(e);
                    }
                    catch (IOException e) {
                        Log.ignore(e);
                    }
                    catch (InterruptedException x) {
                        Log.ignore(x);
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Log.warn(e);
                    }
                }
            }
            finally {
                current.setPriority(old_priority);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractConnector.this.close();
                    }
                }
                catch (IOException e) {
                    Log.warn(e);
                }
                AbstractConnector abstractConnector2 = AbstractConnector.this;
                synchronized (abstractConnector2) {
                    if (AbstractConnector.this._acceptorThread != null) {
                        ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = null;
                    }
                }
            }
        }
    }
}

