/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class XmlStreamHelper {

    /**
     * XmlStreamHelper :
     * utility class all provided methods are accessible the static way
     */

    private XmlStreamHelper() {// empty
}

    /**
     * getUrl :
     * @param wikitty 
     * @return String 
     */

    public static String getUrl(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
        return value;
}

    /**
     * setUrl :
     * @param wikitty 
     * @param url 
     * @return String 
     */

    public static String setUrl(Wikitty wikitty, String url) {
        String oldValue = getUrl(wikitty);
        wikitty.setField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL, url);
        return oldValue;
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME, name);
        return oldValue;
}

    /**
     * getFormTypeName :
     * @param wikitty 
     * @return String 
     */

    public static String getFormTypeName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
        return value;
}

    /**
     * setFormTypeName :
     * @param wikitty 
     * @param formTypeName 
     * @return String 
     */

    public static String setFormTypeName(Wikitty wikitty, String formTypeName) {
        String oldValue = getFormTypeName(wikitty);
        wikitty.setField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME, formTypeName);
        return oldValue;
}

    /**
     * getImportTime :
     * @param wikitty 
     * @return String 
     */

    public static String getImportTime(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_IMPORTTIME);
        return value;
}

    /**
     * setImportTime :
     * @param wikitty 
     * @param importTime 
     * @return String 
     */

    public static String setImportTime(Wikitty wikitty, String importTime) {
        String oldValue = getImportTime(wikitty);
        wikitty.setField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_IMPORTTIME, importTime);
        return oldValue;
}

    /**
     * getXmlFieldBinding :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getXmlFieldBinding(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, String.class);
        return result;
}

    /**
     * setXmlFieldBinding :
     * @param wikitty 
     * @param xmlFieldBinding 
     */

    public static void setXmlFieldBinding(Wikitty wikitty, Set<String> xmlFieldBinding) {
        wikitty.setField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, xmlFieldBinding);
}

    /**
     * addAllXmlFieldBinding :
     * @param wikitty 
     * @param xmlFieldBinding 
     */

    public static void addAllXmlFieldBinding(Wikitty wikitty, Set<String> xmlFieldBinding) {
        if(xmlFieldBinding != null){
            for (String id:xmlFieldBinding){
                addXmlFieldBinding(wikitty, id);
            }
        }
}

    /**
     * addXmlFieldBinding :
     * @param wikitty 
     * @param element 
     */

    public static void addXmlFieldBinding(Wikitty wikitty, String element) {
        wikitty.addToField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, element);
}

    /**
     * removeXmlFieldBinding :
     * @param wikitty 
     * @param element 
     */

    public static void removeXmlFieldBinding(Wikitty wikitty, String element) {
        wikitty.removeFromField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, element);
}

    /**
     * clearXmlFieldBinding :
     * @param wikitty 
     */

    public static void clearXmlFieldBinding(Wikitty wikitty) {
        wikitty.clearField(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
            Object f2 = w2.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
            Object f2 = w2.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
            Object f2 = w2.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_IMPORTTIME);
            Object f2 = w2.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_IMPORTTIME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
            Object f2 = w2.getFieldAsObject(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(XmlStream.EXT_XMLSTREAM);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : XmlStreamAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //XmlStreamHelper
