/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class StatusHelper {

    /**
     * StatusHelper :
     * utility class all provided methods are accessible the static way
     */

    private StatusHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Status.EXT_STATUS, Status.FIELD_STATUS_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Status.EXT_STATUS, Status.FIELD_STATUS_NAME, name);
        return oldValue;
}

    /**
     * getValue :
     * @param wikitty 
     * @return int 
     */

    public static int getValue(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Status.EXT_STATUS, Status.FIELD_STATUS_VALUE);
        return value;
}

    /**
     * setValue :
     * @param wikitty 
     * @param value 
     * @return int 
     */

    public static int setValue(Wikitty wikitty, int value) {
        int oldValue = getValue(wikitty);
        wikitty.setField(Status.EXT_STATUS, Status.FIELD_STATUS_VALUE, value);
        return oldValue;
}

    /**
     * getDescription :
     * @param wikitty 
     * @return String 
     */

    public static String getDescription(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Status.EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
        return value;
}

    /**
     * setDescription :
     * @param wikitty 
     * @param description 
     * @return String 
     */

    public static String setDescription(Wikitty wikitty, String description) {
        String oldValue = getDescription(wikitty);
        wikitty.setField(Status.EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION, description);
        return oldValue;
}

    /**
     * getModifiable :
     * @param wikitty 
     * @return boolean 
     */

    public static boolean getModifiable(Wikitty wikitty) {
        boolean value = wikitty.getFieldAsBoolean(Status.EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
        return value;
}

    /**
     * setModifiable :
     * @param wikitty 
     * @param modifiable 
     * @return boolean 
     */

    public static boolean setModifiable(Wikitty wikitty, boolean modifiable) {
        boolean oldValue = getModifiable(wikitty);
        wikitty.setField(Status.EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE, modifiable);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_NAME);
            Object f2 = w2.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_VALUE);
            Object f2 = w2.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_VALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
            Object f2 = w2.getFieldAsObject(Status.EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Status.EXT_STATUS);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : StatusAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //StatusHelper
