package com.jurismarches.vradi.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityBean;

public class XmlFieldBindingBean extends BusinessEntityBean implements XmlFieldBinding {

    private static final long serialVersionUID = -278663925L;

    public XmlFieldBindingBean() {
        super();
    }

    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChange.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChange.removePropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		propertyChange.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		propertyChange.removePropertyChangeListener(propertyName, listener);
	}

    public Set<String> XmlFieldBinding$xmlField;

    public String XmlFieldBinding$formField;

    public String XmlFieldBinding$defaultValue;

    public Set<String> getXmlField() {
        return XmlFieldBinding$xmlField;
    }

    public void addXmlField(String element) {
        XmlFieldBinding$xmlField.add(element);
        propertyChange.firePropertyChange("xmlField", null, XmlFieldBinding$xmlField);
    }
    
    public void removeXmlField(String element) {
        XmlFieldBinding$xmlField.remove(element);
        propertyChange.firePropertyChange("xmlField", null, XmlFieldBinding$xmlField);
    }
    
    public void clearXmlField() {
        XmlFieldBinding$xmlField.clear();
        propertyChange.firePropertyChange("xmlField", null, XmlFieldBinding$xmlField);
    }


    public void setFormField(String value) {
        Object oldValue = XmlFieldBinding$formField; 
        this.XmlFieldBinding$formField = value;
        propertyChange.firePropertyChange("formField", oldValue, value);
    }

    public String getFormField() {
        return XmlFieldBinding$formField;
    }


    public void setDefaultValue(String value) {
        Object oldValue = XmlFieldBinding$defaultValue; 
        this.XmlFieldBinding$defaultValue = value;
        propertyChange.firePropertyChange("defaultValue", oldValue, value);
    }

    public String getDefaultValue() {
        return XmlFieldBinding$defaultValue;
    }


} //XmlFieldBindingBean
