package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class SessionImpl extends BusinessEntityWikitty implements Session {

    private static final long serialVersionUID = 1999397049L;

    static final protected List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSession =
        new WikittyExtension(EXT_SESSION, "", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date sessionDate unique",
				"Numeric num unique",
				"Numeric status unique",
				"String paragraph unique",
				"Wikitty sending[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
        exts.add(extensionSession);

        extensions = Collections.unmodifiableList(exts);
    }

	public SessionImpl() {
		super();
	}

    public SessionImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SessionImpl(Wikitty wi) {
		super(wi);
	}


    public void setSessionDate(Date sessionDate) {
        getWikitty().setField(EXT_SESSION, "sessionDate", sessionDate);
    }

    public Date getSessionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SESSION, "sessionDate");
        return result;
    }


    public void setNum(int num) {
        getWikitty().setField(EXT_SESSION, "num", num);
    }

    public int getNum() {
        int result = getWikitty().getFieldAsInt(EXT_SESSION, "num");
        return result;
    }


    public void setStatus(int status) {
        getWikitty().setField(EXT_SESSION, "status", status);
    }

    public int getStatus() {
        int result = getWikitty().getFieldAsInt(EXT_SESSION, "status");
        return result;
    }


    public void setParagraph(String paragraph) {
        getWikitty().setField(EXT_SESSION, "paragraph", paragraph);
    }

    public String getParagraph() {
        String result = getWikitty().getFieldAsString(EXT_SESSION, "paragraph");
        return result;
    }

    public Set<String> getSending() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_SESSION, "sending", String.class);
        return result;
    }

    public void addSending(String element) {
        getWikitty().addToField(EXT_SESSION, "sending", element);
    }
    
    public void removeSending(String element) {
        getWikitty().removeFromField(EXT_SESSION, "sending", element);
    }
    
    public void clearSending() {
        getWikitty().clearField(EXT_SESSION, "sending");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //SessionImpl
