package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class FormImpl extends com.jurismarches.vradi.entities.InfogeneImpl implements Form, Infogene {

    private static final long serialVersionUID = -63690911L;

    static final protected List<WikittyExtension> extensions;
    static final public WikittyExtension extensionForm =
        new WikittyExtension(EXT_FORM, "3.0", Infogene.EXT_INFOGENE,
		    WikittyUtil.buildFieldMapExtension(
				"Date datePub unique",
				"Date datePeremption unique",
				"String thesaurus[0-*] unique",
				"String files[0-*] unique",
				"String attachments[0-*] unique",
				"String xmlStreamURL unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(InfogeneImpl.extensions);

        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
        exts.add(extensionForm);

        extensions = Collections.unmodifiableList(exts);
    }

	public FormImpl() {
		super();
	}

    public FormImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public FormImpl(Wikitty wi) {
		super(wi);
	}


    public void setDatePub(Date datePub) {
        getWikitty().setField(EXT_FORM, "datePub", datePub);
    }

    public Date getDatePub() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePub");
        return result;
    }


    public void setDatePeremption(Date datePeremption) {
        getWikitty().setField(EXT_FORM, "datePeremption", datePeremption);
    }

    public Date getDatePeremption() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePeremption");
        return result;
    }

    public Set<String> getThesaurus() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "thesaurus", String.class);
        return result;
    }

    public void addThesaurus(String element) {
        getWikitty().addToField(EXT_FORM, "thesaurus", element);
    }
    
    public void removeThesaurus(String element) {
        getWikitty().removeFromField(EXT_FORM, "thesaurus", element);
    }
    
    public void clearThesaurus() {
        getWikitty().clearField(EXT_FORM, "thesaurus");
    }

    public Set<String> getFiles() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "files", String.class);
        return result;
    }

    public void addFiles(String element) {
        getWikitty().addToField(EXT_FORM, "files", element);
    }
    
    public void removeFiles(String element) {
        getWikitty().removeFromField(EXT_FORM, "files", element);
    }
    
    public void clearFiles() {
        getWikitty().clearField(EXT_FORM, "files");
    }

    public Set<String> getAttachments() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "attachments", String.class);
        return result;
    }

    public void addAttachments(String element) {
        getWikitty().addToField(EXT_FORM, "attachments", element);
    }
    
    public void removeAttachments(String element) {
        getWikitty().removeFromField(EXT_FORM, "attachments", element);
    }
    
    public void clearAttachments() {
        getWikitty().clearField(EXT_FORM, "attachments");
    }


    public void setXmlStreamURL(String xmlStreamURL) {
        getWikitty().setField(EXT_FORM, "xmlStreamURL", xmlStreamURL);
    }

    public String getXmlStreamURL() {
        String result = getWikitty().getFieldAsString(EXT_FORM, "xmlStreamURL");
        return result;
    }


    public void setId(String id) {
        getWikitty().setField(EXT_INFOGENE, "id", id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "id");
        return result;
    }


    public void setObjet(String objet) {
        getWikitty().setField(EXT_INFOGENE, "objet", objet);
    }

    public String getObjet() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "objet");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_INFOGENE, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_INFOGENE, "creationDate");
        return result;
    }


    public void setSourceURL(String sourceURL) {
        getWikitty().setField(EXT_INFOGENE, "sourceURL", sourceURL);
    }

    public String getSourceURL() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceURL");
        return result;
    }


    public void setSourceText(String sourceText) {
        getWikitty().setField(EXT_INFOGENE, "sourceText", sourceText);
    }

    public String getSourceText() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceText");
        return result;
    }


    public void setEntity(String entity) {
        getWikitty().setField(EXT_INFOGENE, "entity", entity);
    }

    public String getEntity() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "entity");
        return result;
    }


    public void setCountry(String country) {
        getWikitty().setField(EXT_INFOGENE, "country", country);
    }

    public String getCountry() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "country");
        return result;
    }


    public void setDepartment(String department) {
        getWikitty().setField(EXT_INFOGENE, "department", department);
    }

    public String getDepartment() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "department");
        return result;
    }


    public void setDescription(String description) {
        getWikitty().setField(EXT_INFOGENE, "description", description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "description");
        return result;
    }

    public Set<String> getTag() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_INFOGENE, "tag", String.class);
        return result;
    }

    public void addTag(String element) {
        getWikitty().addToField(EXT_INFOGENE, "tag", element);
    }
    
    public void removeTag(String element) {
        getWikitty().removeFromField(EXT_INFOGENE, "tag", element);
    }
    
    public void clearTag() {
        getWikitty().clearField(EXT_INFOGENE, "tag");
    }


    public void setStatus(String status) {
        getWikitty().setField(EXT_INFOGENE, "status", status);
    }

    public String getStatus() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "status");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //FormImpl
