/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase08preparepackage;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexMojo
extends AbstractAndroidMojo {
    private String[] jvmArguments;
    private boolean coreLibrary;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separator + "classes.dex");
        File inputFile = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar");
        if (this.generateApk) {
            this.runDex(executor, outputFile, inputFile);
        }
        if (this.attachJar) {
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), inputFile);
        }
        if (this.attachSources) {
            File apksources = this.createApkSourcesFile();
            this.projectHelper.attachArtifact(this.project, "apksources", apksources);
        }
    }

    private void runDex(CommandExecutor executor, File outputFile, File inputFile) throws MojoExecutionException {
        File classesOutputDirectory = new File(this.project.getBuild().getDirectory(), "android-classes");
        ArrayList<String> commands = new ArrayList<String>();
        if (this.jvmArguments != null) {
            for (String jvmArgument : this.jvmArguments) {
                if (jvmArgument == null) continue;
                if (jvmArgument.startsWith("-")) {
                    jvmArgument = jvmArgument.substring(1);
                }
                commands.add("-J" + jvmArgument);
            }
        }
        commands.add("--dex");
        commands.add("--output=" + outputFile.getAbsolutePath());
        commands.add(classesOutputDirectory.getAbsolutePath());
        if (this.coreLibrary) {
            commands.add("--core-library");
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("dx") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("dx"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    protected File createApkSourcesFile() throws MojoExecutionException {
        File apksources = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".apksources");
        FileUtils.deleteQuietly((File)apksources);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apksources);
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src/main/java");
            this.addJavaResources(jarArchiver, this.project.getBuild().getResources());
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apksource file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apksource file.", (Exception)e);
        }
        return apksources;
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) throws ArchiverException {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources) throws ArchiverException {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource) throws ArchiverException {
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists()) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash("src/main/resources"));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }
}

