/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PushMojo
extends AbstractMojo {
    private File source;
    private File destination;
    protected String device;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.device)) {
            if ("usb".equals(this.device)) {
                commands.add("-d");
            } else if ("emulator".equals(this.device)) {
                commands.add("-e");
            } else {
                commands.add("-s");
                commands.add(this.device);
            }
        }
        commands.add("push");
        commands.add(this.source.getAbsolutePath());
        commands.add(this.destination.getAbsolutePath());
        this.getLog().info((CharSequence)("adb " + ((Object)commands).toString()));
        try {
            executor.executeCommand("adb", commands);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Push failed.", (Exception)e);
        }
    }
}

