/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.util;

import com.javadocmd.simplelatlng.util.LengthUnit;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class LatLngConfig {
    public static final double DEGREE_TOLERANCE = 1.0E-6;
    public static final NumberFormat DEGREE_FORMAT = new DecimalFormat("0.000000");
    public static final double EARTH_MEAN_RADIUS_KILOMETERS = 6371.009;
    private static double[] EARTH_RADIUS;

    public static double getEarthRadius(LengthUnit unit) {
        return EARTH_RADIUS[unit.ordinal()];
    }

    public static synchronized void setEarthRadius(double radius, LengthUnit unit) {
        EARTH_RADIUS = new double[LengthUnit.values().length];
        for (LengthUnit toUnit : LengthUnit.values()) {
            LatLngConfig.EARTH_RADIUS[toUnit.ordinal()] = unit.convertTo(toUnit, radius);
        }
    }

    private LatLngConfig() {
    }

    public static long doubleToLong(double value) {
        return (long)(value / 1.0E-6);
    }

    public static double longToDouble(long value) {
        return (double)value * 1.0E-6;
    }

    static {
        LatLngConfig.setEarthRadius(6371.009, LengthUnit.KILOMETER);
    }
}

